<?php

namespace app\models;

use Yii;
use phpDocumentor\Reflection\Types\Null_;
use app\controllers\MovefuelratioController;

/**
 * This is the model class for table "fuelrequest".
 *
 * @property int $id
 * @property int $truckId
 * @property int $driverId
 * @property string $fueldate
 * @property string $recorddate
 * @property string $volume
 * @property string $lastdistance
 * @property string $priceperlitre
 * @property int $status
 *
 * @property Cardrivers $driver
 * @property Trailers $truck
 */
class Fuelrequest extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public $from, $to; 
    public static function tableName()
    {
        return 'fuelrequest';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['truckId', 'driverId', 'fueldate', 'recorddate', 'volume', 'lastdistance', 'priceperlitre','byy'], 'required'],
            [['status'], 'integer'],
            [['fueldate', 'recorddate'], 'safe'],
            [['volume', 'lastdistance', 'priceperlitre'], 'number'],
            [['driverId'], 'exist', 'skipOnError' => true, 'targetClass' => Cardrivers::className(), 'targetAttribute' => ['driverId' => 'id']],
            [['truckId'], 'exist', 'skipOnError' => true, 'targetClass' => Cars::className(), 'targetAttribute' => ['truckId' => 'plateno']],
            ['fueldate', 'compare', 'compareValue' => date('Y-m-d'), 'operator' => '<=','message'=>"Date can not be above today" ],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'truckId' => 'Truck',
            'driverId' => 'Driver',
            'fueldate' => 'Fueled date',
            'recorddate' => 'Recorded date',
            'volume' => 'Volume(Lts)',
            'lastdistance' => 'Last distance(Km)',
            'priceperlitre' => 'Price perlitre(Tsh)',
            'status' => 'Status',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getDriver()
    {
        return $this->hasOne(Cardrivers::className(), ['id' => 'driverId']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getTruck()
    {
        return $this->hasOne(Cars::className(), ['plateno' => 'truckId']);
    }
    
    public function checkDublicate($tId,$dt,$vl){
        
        $val=true;
        
        $fuels= Fuelrequest::find()
                ->where(['truckId'=>$tId,'fueldate'=>$dt,'volume'=>$vl])
                ->all();
        
                if ($fuels != null){
                    $val=false;
                }
                
                return $val;
    }
    
    public function getConsumedFuelByEmpty($fId){
        $consumed=0;
        
        $movements= Movements::find()
        ->where(['fuelId'=>$fId])->all();
        
        if ($movements != null) {
            foreach ($movements as $movement) {
                if ($movement->movetype->triptype==2){
                    $consumed=$consumed+ Movefuelratio::getConsumedFuel($movement->movetype->id,$movement->truck->typeId);
                }
            }
        }
        
        return $consumed;
    }
    
    public function getConsumedFuelByFull($fId){
        $consumed=0;
        
        $movements= Movements::find()
        ->where(['fuelId'=>$fId])->all();
        
        if ($movements != null) {
            foreach ($movements as $movement) {
                if ($movement->movetype->triptype==1){
                    $consumed=$consumed+ Movefuelratio::getConsumedFuel($movement->movetype->id,$movement->truck->typeId);
                }
            }
        }
        
        return $consumed;
        
    }
    
    
    public function getConsumedFuelByOther($fId){
        $consumed=0;
        
        $movements= Movements::find()
        ->where(['fuelId'=>$fId])->all();
        
        if ($movements != null) {
            foreach ($movements as $movement) {
                if ($movement->movetype->triptype==3){
                    $consumed=$consumed+ Movefuelratio::getConsumedFuel($movement->movetype->id,$movement->truck->typeId);
                }
            }
        }
        
        
        return $consumed;
    }
    
    public function getTruckActiveFuel($tId,$ec){
        $gouse=null;
        
        $aFuels=Fuelrequest::find()
        ->where(['truckId'=>$tId, 'status'=>1])->all();
        
        if ($aFuels != null){
            foreach ($aFuels as $fuel){
                $consumed= Fuelrequest::getConsumedFuelByEmpty($fuel->id) + Fuelrequest::getConsumedFuelByFull($fuel->id) + Fuelrequest::getConsumedFuelByOther($fuel->id) + Offuels::getConsumedfuels($fuel->id);
                $remaining=$fuel->volume-$consumed;
                
                if ($remaining >= $ec) {
                    $gouse=$fuel->id;
                    break;
                }
            }
        }
        
        return $gouse;
    }
    
    public function countTruckActiveFuel($tId){
         $cnt=0;
        
        $aFuels=Fuelrequest::find()
        ->where(['truckId'=>$tId, 'status'=>1])->all();
        
        if ($aFuels != null){
            foreach ($aFuels as $fuel){
                $consumed= Fuelrequest::getConsumedFuelByEmpty($fuel->id) + Fuelrequest::getConsumedFuelByFull($fuel->id) + Fuelrequest::getConsumedFuelByOther($fuel->id) + Offuels::getConsumedfuels($fuel->id);
                $remaining=$fuel->volume-$consumed;
                
                if ($remaining < 5){
                    $af= Fuelrequest::findOne($fuel->id);
                    $af->status=0;
                    $af->save();
                }else {
                    $cnt++;
                }
            }
        }
        
        return $cnt;
    }
    
    public function getTruckConsumedfuelByTime($tId,$from,$to){
        
        $consumed=0;
        
        $movements= Movements::find()
        ->where("interchangedate >= '$from' and interchangedate <= '$to' and truckId='$tId'")
        ->all();
        
        if ($movements != null){
            foreach ($movements as $movement){
                $consumed=$consumed+Movefuelratio::getConsumedFuel($movement->movetype->id,$movement->truck->typeId);
            }
        }
        
        return $consumed;
    }
    
    
    public function getTruckConsumedfuelByTimeCost($tId,$from,$to){
        
        $cost=0;
        
        $movements= Movements::find()
        ->where("interchangedate >= '$from' and interchangedate <= '$to' and truckId='$tId'")
        ->all();
        
        if ($movements != null){
            foreach ($movements as $movement){
                $cost=$cost+(Movefuelratio::getConsumedFuel($movement->movetype->id,$movement->truck->typeId)*$movement->fuel->priceperlitre);
            }
        }
        
        return $cost;
    }
    
    
    public function getTruckLastFueledDate($tId){
        $dt='Never fueled';
        
        $fuels=Fuelrequest::find()
        ->where(['truckId'=>$tId])->orderBy(['fueldate'=>SORT_DESC])->all();
        
        if ($fuels != null){
            foreach ($fuels as $fuel){
                $dt=date('d-m-Y',strtotime($fuel->fueldate));
                break;
            }
        }
        
        return $dt;
        
    }
    
    public function getTruckFueledAmountByTime($tId,$from,$to){
        
        $total=0;
        
        $fuels=Fuelrequest::find()
        ->where("fueldate >= '$from' and fueldate <= '$to' and truckId=:id",[':id'=>$tId])->all();
        
        if ($fuels != null){
            foreach ($fuels as $fuel){
                $total=$total+ $fuel->volume;
            }
        }
        
        return $total;
    }
}
