<?php

namespace app\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use app\models\Defectivetrucks;

/**
 * DefectivetrucksSearch represents the model behind the search form of `app\models\Defectivetrucks`.
 */
class DefectivetrucksSearch extends Defectivetrucks
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'status'], 'integer'],
            [['carId', 'reason', 'indate', 'outdate'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Defectivetrucks::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'status' => $this->status,
            'indate' => $this->indate,
            'outdate' => $this->outdate,
        ]);

        $query->andFilterWhere(['like', 'carId', $this->carId])
            ->andFilterWhere(['like', 'reason', $this->reason]);

        return $dataProvider;
    }
}
