<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "cfbills".
 *
 * @property int $id
 * @property int $billId
 * @property int $fileId
 *
 * @property Bills $bill
 * @property Cfile $file
 */
class Cfbills extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'cfbills';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['billId', 'fileId'], 'required'],
            [['billId', 'fileId'], 'integer'],
            [['billId'], 'exist', 'skipOnError' => true, 'targetClass' => Bills::className(), 'targetAttribute' => ['billId' => 'id']],
            [['fileId'], 'exist', 'skipOnError' => true, 'targetClass' => Cfile::className(), 'targetAttribute' => ['fileId' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'billId' => 'Bill ID',
            'fileId' => 'File ID',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getBill()
    {
        return $this->hasOne(Bills::className(), ['id' => 'billId']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getFile()
    {
        return $this->hasOne(Cfile::className(), ['id' => 'fileId']);
    }
}
