<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "cars".
 *
 * @property int $typeId
 * @property string $plateno
 * @property int $status
 * @property string $datepurchased
 *
 * @property Cardrivers[] $cardrivers
 * @property Cartype $type
 * @property Trailers[] $trailers
 * @property Trailers[] $trailers0
 */
class Cars extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    
    public $driver, $trailer; 
    
    public static function tableName()
    {
        return 'cars';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['typeId', 'plateno', 'datepurchased'], 'required'],
            [['typeId', 'status','company'], 'integer'],
            [['datepurchased'], 'safe'],
            [['plateno'], 'string', 'max' => 7],
            [['plateno'], 'unique'],
            [['typeId'], 'exist', 'skipOnError' => true, 'targetClass' => Cartype::className(), 'targetAttribute' => ['typeId' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'typeId' => 'Car model',
            'plateno' => 'Plateno',
            'status' => 'Status',
            'datepurchased' => 'Purchased date',
            'trailer'=>'Car trailer',
            'driver'=>'Car driver',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getCardrivers()
    {
        return $this->hasMany(Cardrivers::className(), ['carId' => 'plateno']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getType()
    {
        return $this->hasOne(Cartype::className(), ['id' => 'typeId']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getTrailers()
    {
        return $this->hasMany(Trailers::className(), ['horseid' => 'plateno']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getTrailers0()
    {
        return $this->hasMany(Trailers::className(), ['trailerid' => 'plateno']);
    }
    
    
}
