<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "billcontent".
 *
 * @property int $id
 * @property int $billId
 * @property int $serviceId
 * @property int $count
 * @property string $amount
 *
 * @property Bills $bill
 * @property Servicecost $service
 */
class Billcontent extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    
    public $total;
    
    public static function tableName()
    {
        return 'billcontent';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['billId', 'serviceId', 'count', 'amount'], 'required'],
            [['billId', 'serviceId', 'count'], 'integer'],
            [['amount'], 'number'],
            [['billId'], 'exist', 'skipOnError' => true, 'targetClass' => Bills::className(), 'targetAttribute' => ['billId' => 'id']],
            [['serviceId'], 'exist', 'skipOnError' => true, 'targetClass' => Services::className(), 'targetAttribute' => ['serviceId' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'billId' => 'Bill ID',
            'serviceId' => 'Service/Product',
            'count' => 'Quantity',
            'amount' => 'Amount',
            'total'=>'Total',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getBill()
    {
        return $this->hasOne(Bills::className(), ['id' => 'billId']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getService()
    {
        return $this->hasOne(Services::className(), ['id' => 'serviceId']);
    }
    
    public function getBillCost($id){
        $ret=0;
        
        $contents=Billcontent::find()->where(['billId'=>$id])->all();
        
        if ($contents!=null) {
            foreach ($contents as $content){
                $ret=$ret+($content->amount*$content->count);
            }
        }
        
        return $ret;
    }
    
    public function checkServiceInBill($servid,$billId){
        
        $ret=null;
        
        $contents=Billcontent::find()->where(['billId'=>$billId,'serviceId'=>$servid])->all();
        
        if ($contents != null){
            foreach ($contents as $content){
                $ret=$content->id;
            }
        }
        return $ret;
    }
    
    public function checkServiceAmountInBill($servid,$billId){
        
        $ret=null;
        
        $contents=Billcontent::find()->where(['billId'=>$billId,'serviceId'=>$servid])->all();
        
        if ($contents != null){
            foreach ($contents as $content){
                $ret=$content->amount;
            }
        }
        return $ret;
    }
    
}
