<?php

namespace app\controllers;

use Yii;
use app\models\Cartype;
use app\models\Movetype;
use app\models\MovetypeSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use app\models\Movefuelratio;

/**
 * MovetypeController implements the CRUD actions for Movetype model.
 */
class MovetypeController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Movetype models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new MovetypeSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Movetype model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Movetype model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Movetype();
        
        $ratio= new Movefuelratio();

        if ($model->load(Yii::$app->request->post())) {
            $model->currency=$model->currency; 
            $model->name=strtoupper($model->name);
            
            if ($model->save()){
               
                $types= Cartype::find()
                ->where(['NOT LIKE','name','trailer'])
                ->all();
                
                $status=1;
                
                if ($types != null){
                foreach ($types as $i=>$type){
                    $newratio= new Movefuelratio();
                    if (isset($_POST['Movefuelratio'][$i]['moveconsumption'])){
                        if ($_POST['Movefuelratio'][$i]['moveconsumption'] != null){
                            $newratio->cartypeId=$type->id;
                            $newratio->movetypeId=$model->id;
                            $newratio->moveconsumption=$_POST['Movefuelratio'][$i]['moveconsumption'];
                            if (!$newratio->save()){
                                $status=0;
                            }
                        }
                } } } }
            
          if ($status==1){
              \Yii::$app->session->setFlash('success','Successfull saved new type of movement with its consumptions');
              return $this->redirect(['view', 'id' => $model->id]);
          }elseif ($status==0){
              \Yii::$app->session->setFlash('error','There is an error on saving movement with its consumptions');
              return $this->redirect(['view', 'id' => $model->id]);
          }
        
        }

        return $this->render('create', [
            'model' => $model,'ratio'=>$ratio,
        ]);
    }

    /**
     * Updates an existing Movetype model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);
        $r= Movefuelratio::find()
        ->where(['movetypeId'=>$id])
        ->one();
        
        if ($r != null) $ratio=$r;
        else $ratio=new Movefuelratio();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            
            $types= Cartype::find()
            ->where(['NOT LIKE','name','trailer'])
            ->all();
            
            $status=1;
            
            if ($types != null){
                foreach ($types as $i=>$type){
                    $newratio= new Movefuelratio();
                    if (isset($_POST['Movefuelratio'][$i]['moveconsumption'])){
                        $newratio->cartypeId=$type->id;
                        $newratio->movetypeId=$model->id;
                        $newratio->moveconsumption=$_POST['Movefuelratio'][$i]['moveconsumption'];
                        
                        if (!$newratio->save()){
                            $status=0;
                        }
                    } } }
                    
                    if ($status==1){
                        \Yii::$app->session->setFlash('success','Successfull saved new type of movement with its consumptions');
                        return $this->redirect(['view', 'id' => $model->id]);
                    }elseif ($status==0){
                        \Yii::$app->session->setFlash('error','There is an error on saving movement with its consumptions');
                        return $this->redirect(['view', 'id' => $model->id]);
                    }
        }

        return $this->render('update', [
            'model' => $model,'ratio'=>$ratio,
        ]);
    }

    /**
     * Deletes an existing Movetype model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Movetype model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Movetype the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Movetype::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
}
