<?php

namespace app\controllers;

use Yii;
use yii2tech\spreadsheet\Spreadsheet;
use yii\data\ArrayDataProvider;
use app\models\Movefuelratio;
use app\models\Movements;
use app\models\MovementsSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use app\models\Fuelrequest;
use yii\data\ActiveDataProvider;
use app\models\Cardrivers;
use app\models\Cars;
use app\models\Cartype;
use app\models\Movetype;
use app\models\Trafficoffences;
use app\models\Clients;
use kartik\mpdf\Pdf;
use app\models\Wstoredispatch;

/**
 * MovementsController implements the CRUD actions for Movements model.
 */
class MovementsController extends Controller
{
    public function init() {
        $this->layout = 'operations';
    }
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Movements models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new MovementsSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }
    
    public function actionClientmovementsbydate()
    {
        $model=new Movements();
        $client=null;
        
        $dataProvider = new ActiveDataProvider([
            'query' => Movements::find()->where('company=:c',[':c'=>\Yii::$app->session->get('company')]),
            'pagination' => [
                'pageSize' => 50,
            ],
            'sort'=> ['defaultOrder' => ['interchangedate'=>SORT_DESC]],
        ]);
        
        if (isset($_POST['Movements'])) {
            $from=date('Y-m-d',strtotime($_POST['Movements']['from']));
            $to=date('Y-m-d',strtotime($_POST['Movements']['to']));
            $cnt=$_POST['Movements']['clientId'];
                
            $dataProvider = new ActiveDataProvider([
            'query'=>Movements::find()
                ->where('interchangedate >= :from and interchangedate <= :to and clientId=:id and company=:c', [':from'=>$from,':to'=>$to,':id'=>$cnt,':c'=>\Yii::$app->session->get('company')]),
                'pagination' => [
                    'pageSize' => 50,
                ],
                'sort'=> ['defaultOrder' => ['interchangedate'=>SORT_DESC]],
            ]);
            
           $client=$cnt;
        }
        
        return $this->render('clientmovementsbydate', [
            'dataProvider' => $dataProvider,
            'model'=>$model,
            'client'=>$client,
        ]);
    }

    /**
     * Displays a single Movements model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Movements model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Movements();

        if ($model->load(Yii::$app->request->post())) {
            
            $moveconsumption=$model->movetypeId!=null?Movefuelratio::getConsumedFuel($model->movetype->id,$model->truck->typeId):0;
            $fId=Fuelrequest::getTruckActiveFuel($model->truckId,$moveconsumption);
            if ($fId !=null && $model->movetype->movefuelratios!=null){
                
                $model->interchangedate=date('Y-m-d',strtotime($model->interchangedate));
                $model->containerno=trim(strtoupper($model->containerno));
                $model->company=\Yii::$app->session->get('company');
                $model->registereddate=date('Y-m-d');
                $model->byy=\Yii::$app->user->getId();
                $model->fuelId=$fId;
                $dublicatecheck=Movements::checkDublicateMovement($model->movetypeId,strtolower($model->containerno),$model->interchangedate,$model->clientId);
                
                if ($dublicatecheck==null){
                    if($model->save()){
                        \Yii::$app->session->setFlash('success','Successfull saved new movement');
                    return $this->redirect(['create']);
                    }
                }else {
                    \Yii::$app->session->setFlash('error','Dublicate movement registered');
                    return $this->redirect(['update','id'=>$dublicatecheck->id]);
                }
            }else {
                \Yii::$app->session->setFlash('error','This truck has no fuel to complete this movement / Movement has not been assigned fuel ratio');
                return $this->redirect(['fuelrequest/create','id'=>$model->truckId]);
            }
        }
            return $this->render('create', [
                'model' => $model,
            ]);
    }

    /**
     * Updates an existing Movements model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post())) {
            
            $model->interchangedate=date('Y-m-d',strtotime($model->interchangedate));
            $model->containerno=strtoupper($model->containerno);
            $model->registereddate=date('Y-m-d');
            $model->byy=\Yii::$app->user->getId();
            
            if ($model->save()){
            \Yii::$app->session->setFlash('success','Successfull saved new movement');
            return $this->redirect(['index']);
            }
        }

        $model->interchangedate=date('d-M-Y',strtotime($model->interchangedate));
        
        return $this->render('update', [
            'model' => $model,
        ]);
    }
    
    
    public function actionDriversincentive($id)
    {
        if ($id==2) { $this->layout= 'accounts'; }
        
        $drivers= Cardrivers::find()
        ->where(['status'=>1])->all();
        
        $movement=new Movements;
        
        $allDrivers=null;
        $average=null;
        $cnt=0;
        $from=date('1970-01-01');
        $to=date('1970-01-01');
        $data=null;
        $dtProvider=null;
        
        if (isset($_POST['Movements'])){
            $from=date('Y-m-d',strtotime($_POST['Movements']['from']));
            $to=date('Y-m-d',strtotime($_POST['Movements']['to']));
        if($drivers!=null and $to>=$from){
            foreach ($drivers as $driver){
                $allDrivers[$cnt]['name']=$driver->user->firstname.' '.$driver->user->lastname;
                $allDrivers[$cnt]['foty']=Movements::driverAmountOfLoadBySizeTime($driver->id,$from,$to,4);
                $allDrivers[$cnt]['twenty']=Movements::driverAmountOfLoadBySizeTime($driver->id,$from,$to,2);
                $allDrivers[$cnt]['other']=Movements::driverAmountOfLoadBySizeTime($driver->id,$from,$to,0);
                $allDrivers[$cnt]['moves']=Movements::driverMovementsByTime($driver->id,$from,$to);
                $allDrivers[$cnt]['incentive']=Movetype::driverIncentiveByTime($driver->id,$from,$to);
                $allDrivers[$cnt]['trafficoffence']=Trafficoffences::calculateDriverCost($driver->id,$from,$to);
                $allDrivers[$cnt]['driverId']=$driver->id;
                
                $average[$cnt]['val']=$allDrivers[$cnt]['moves'];
                $cnt++;
            }
            array_multisort($average,SORT_DESC,$allDrivers);
            
        }else {
            \Yii::$app->session->setFlash('error','From date must be less than to date');
        }
           
          
        }
        
        
        
        return $this->render('driversincentive',['drivers'=>$allDrivers,'movement'=>$movement,'from'=>$from,'to'=>$to]);
    }

    /**
     * Deletes an existing Movements model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Movements model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Movements the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Movements::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
    
    public function actionPrintincentives($from,$to){
        
        
        $drivers= Cardrivers::find()
        ->where(['status'=>1])->all();
        
        $movement=new Movements;
        
        $allDrivers=null;
        $average=null;
        $cnt=0;
      
            if($drivers!=null and $to>=$from){
                foreach ($drivers as $driver){
                    $incentive=Movetype::driverIncentiveByTime($driver->id,$from,$to);
                    if ($incentive>0){
                    $allDrivers[$cnt]['name']=$driver->user->firstname.' '.$driver->user->lastname;
                    $allDrivers[$cnt]['foty']=Movements::driverAmountOfLoadBySizeTime($driver->id,$from,$to,4);
                    $allDrivers[$cnt]['twenty']=Movements::driverAmountOfLoadBySizeTime($driver->id,$from,$to,2);
                    $allDrivers[$cnt]['other']=Movements::driverAmountOfLoadBySizeTime($driver->id,$from,$to,0);
                    $allDrivers[$cnt]['moves']=Movements::driverMovementsByTime($driver->id,$from,$to);
                    $allDrivers[$cnt]['incentive']=$incentive;
                    $allDrivers[$cnt]['deduction']=Trafficoffences::calculateDriverCost($driver->id,$from,$to);
                    $allDrivers[$cnt]['netpay']=Movetype::driverIncentiveByTime($driver->id,$from,$to)-Trafficoffences::calculateDriverCost($driver->id,$from,$to);
                    $allDrivers[$cnt]['driverId']=$driver->id;
                    
                    $average[$cnt]['val']=$allDrivers[$cnt]['moves'];
                    $cnt++;
                    }
                }
               if ($allDrivers != null and $average!= null) array_multisort($average,SORT_DESC,$allDrivers);
            }
        
        $exporter = new Spreadsheet([
            'dataProvider' => new ArrayDataProvider([
                'allModels' => $allDrivers
            ]),
            
            'columns' => [
                [
                    'attribute' => 'name',
                    'contentOptions' => [
                        'width' => [
                            '35px'
                        ],
                    ],
                ],
                [
                    'attribute' => 'foty',
                ],
                [
                    'attribute' => 'twenty',
                ],
                [
                    'attribute' => 'other',
                ],
                [
                    'attribute' => 'moves',
                ],
                [
                    'attribute' => 'incentive',
                ],
                [
                    'attribute' => 'deduction',
                ],
                [
                    'attribute' => 'netpay',
                ],
            ],
        ]);
        
        return $exporter->send('incentives.xls');
    }
    
    
    public function actionPrintdrivercontainerlist($from,$to,$driverId){
        
        
        $containers=Movements::find()
        ->where("interchangedate > '$from' and interchangedate < '$to' and driverId='$driverId'")->orderBy(['interchangedate'=>SORT_DESC])->all();
        
        $cnt=0;
        
        if($containers!=null){
            foreach ($containers as $container){
                $allDrivers[$cnt]['number']=$container->containerno;
                $allDrivers[$cnt]['size']=Movetype::getContainerSize($container->size);
                $allDrivers[$cnt]['type']=Movetype::findOne($container->movetypeId)->name;
                $allDrivers[$cnt]['date']=date('d-m-Y',strtotime($container->interchangedate));
                $cnt++;
            }
        }
        
        $exporter = new Spreadsheet([
            'dataProvider' => new ArrayDataProvider([
                'allModels' => $allDrivers
            ]),
            
            'columns' => [
                
                [
                    'attribute' => 'number',
                ],
                [
                    'attribute' => 'size',
                ],
                [
                    'attribute' => 'type',
                ],
                [
                    'attribute' => 'date',
                ],
            ],
        ]);
        
        return $exporter->send('drivercontainerlist.xls');
    }

    
    public function actionPrintclientcontainerlist($from,$to,$clientId,$shippingline){
        
        $allDrivers=null;
        $costrecords=null;
        
        if ($shippingline==0){
            
            $containers=Movements::find()
            ->where("interchangedate >= '$from' and interchangedate <= '$to' and clientId='$clientId'")->orderBy(['interchangedate'=>SORT_DESC])->all();
            
            $cnt=0;
            $tttwenty=0;
            $ttforty=0;
            $ttothers=0;
            $ttcharges=0;
            
            if($containers!=null){
                foreach ($containers as $container){
                    $allDrivers[$cnt]['container']=$container->containerno;
                    $allDrivers[$cnt]['size']=Movetype::getContainerSize($container->size);
                    $allDrivers[$cnt]['movement']=Movetype::findOne($container->movetypeId)->name;
                    $allDrivers[$cnt]['truck']=$container->truckId;
                    $allDrivers[$cnt]['driver']=$container->driver->user->fullName;
                    $allDrivers[$cnt]['date']=date('d-m-Y',strtotime($container->interchangedate));
                    $allDrivers[$cnt]['shippingline']=Clients::findOne($container->shippingline)->name;
                    $cnt++;
                    
                    if ($container->size==2){
                        $tttwenty++;
                        $ttcharges=$ttcharges+Movetype::findOne($container->movetypeId)->twentypay;
                    }elseif ($container->size==4){
                        $ttforty++;
                        $ttcharges=$ttcharges+Movetype::findOne($container->movetypeId)->fortypay;
                    }else{
                        $ttothers++;
                        $ttcharges=$ttcharges+Movetype::findOne($container->movetypeId)->otherpay;
                    }
                }
                
                $costrecords[0]['Client']=Clients::findOne($clientId)->name;
                $costrecords[0]['20ft']=$tttwenty;
                $costrecords[0]['40ft']=$ttforty;
                $costrecords[0]['others']=$tttwenty;
                $costrecords[0]['TotalCharges']=$ttcharges;
            }
        }else{
            
            $containers=Movements::find()
            ->where("interchangedate >= '$from' and interchangedate <= '$to' and clientId='$clientId' and shippingline='$shippingline'")->orderBy(['interchangedate'=>SORT_DESC])->all();
            
            $cnt=0;
            $tttwenty=0;
            $ttforty=0;
            $ttothers=0;
            $ttcharges=0;
            
            if($containers!=null){
                foreach ($containers as $container){
                    $allDrivers[$cnt]['container']=$container->containerno;
                    $allDrivers[$cnt]['size']=Movetype::getContainerSize($container->size);
                    $allDrivers[$cnt]['movement']=Movetype::findOne($container->movetypeId)->name;
                    $allDrivers[$cnt]['truck']=$container->truckId;
                    $allDrivers[$cnt]['driver']=$container->driver->user->fullName;
                    $allDrivers[$cnt]['date']=date('d-m-Y',strtotime($container->interchangedate));
                    $allDrivers[$cnt]['shippingline']=Clients::findOne($shippingline)->name;
                    $cnt++;
                    
                    if ($container->size==2){
                        $tttwenty++;
                        $ttcharges=$ttcharges+Movetype::findOne($container->movetypeId)->twentypay;
                    }elseif ($container->size==4){
                        $ttforty++;
                        $ttcharges=$ttcharges+Movetype::findOne($container->movetypeId)->fortypay;
                    }else{
                        $ttothers++;
                        $ttcharges=$ttcharges+Movetype::findOne($container->movetypeId)->otherpay;
                    }
                }
                
                $costrecords[0]['Client']=Clients::findOne($clientId)->name;
                $costrecords[0]['20ft']=$tttwenty;
                $costrecords[0]['40ft']=$ttforty;
                $costrecords[0]['others']=$tttwenty;
                $costrecords[0]['TotalCharges']=$ttcharges;
                
            }
        }
        
        $exporter = (new Spreadsheet([
            'title' => 'ContainerList',
            'dataProvider' => new ArrayDataProvider([
                'allModels' => $allDrivers
            ]),
            
            'columns' => [
                
                [
                    'attribute' => 'container',
                ],
                [
                    'attribute' => 'size',
                ],
                [
                    'attribute' => 'movement',
                ],
                [
                    'attribute' => 'truck',
                ],
                [
                    'attribute' => 'driver',
                ],
                [
                    'attribute' => 'date',
                ],
                [
                    'attribute' => 'shippingline',
                ],
            ],
        ]))->render();
                
        $exporter->configure([ // update spreadsheet configuration
            'title' => 'InvoicesDetails',
            'dataProvider' => new ArrayDataProvider([
                'allModels' =>$costrecords
            ]),
            
            'columns' => [
                
                [
                    'attribute' => 'Client',
                ],
                [
                    'attribute' => '20ft',
                ],
                [
                    'attribute' => '40ft',
                ],
                [
                    'attribute' => 'others',
                ],
                [
                    'attribute' => 'TotalCharges',
                ],
            ],
            
        ])->render();
        
        return $exporter->send('clientcontainerlist.xls');
    }
    
    
    public function actionDrivercontainerlist($from,$to,$driverId){
        
        $containers=Movements::find()
        ->where("interchangedate > '$from' and interchangedate < '$to' and driverId='$driverId'")->orderBy(['interchangedate'=>SORT_DESC])->all();
        
        return $this->render('drivercontainerlist',['containers'=>$containers,'driverId'=>$driverId,'from'=>$from,'to'=>$to]);
    }
    
    public function actionClientcontainerlist($from,$to,$clientId){
        
        $containers=Movements::find()
        ->where("interchangedate >= '$from' and interchangedate <= '$to' and clientId='$driverId'")->orderBy(['interchangedate'=>SORT_DESC])->all();
        
        return $this->render('drivercontainerlist',['containers'=>$containers,'driverId'=>$driverId,'from'=>$from,'to'=>$to]);
    }
    
    public function actionReport()
    {
        $this->layout='main';
        $model = new Movements();
        
        if (isset($_POST['Movements'])) {
            
            if($_POST['Movements']['to'] > $_POST['Movements']['from']){
                $f=date('Y-m-d',strtotime($_POST['Movements']['from']));
                $t=date('Y-m-d',strtotime($_POST['Movements']['to']));
                $trucks=Cars::find()->where(['typeId' =>Cartype::getHorsesId(),'status'=>1,'company'=>\Yii::$app->session->get('company')])-> all();
                $fuelaverage=array();
                $fuelrecords=array();
                $summary=array();
                $cnt=0;
                $totalfuel=0;
                $totalspare=0;
                $totalince=0;
                $totalincome=0;
                
                if ($trucks != null){
                    foreach ($trucks as $truck){
                        $fuelrecords[$cnt]['car']=$truck->plateno;
                        $fuelrecords[$cnt]['trips']=Movements::carMovementsByTime($truck->plateno,$f,$t);
                        $fuelrecords[$cnt]['volume']=Fuelrequest::getTruckFueledAmountByTime($truck->plateno,$f,$t);
                        $fuelrecords[$cnt]['fuelcost']=Fuelrequest::getTruckConsumedfuelByTimeCost($truck->plateno,$f,$t);
                        $fuelrecords[$cnt]['sparecost']=Wstoredispatch::getCarCostByTime($truck->plateno,$f,$t);
                        $fuelrecords[$cnt]['incecost']=Movetype::carIncentiveByTime($truck->plateno,$f,$t);
                        $fuelrecords[$cnt]['income']=Movements::carAmountOfIncomeByTime($truck->plateno,$f,$t);
                        
                        $fuelaverage[$cnt]['av']=$fuelrecords[$cnt]['income'];
                        
                        
                        $totalfuel=$totalfuel+$fuelrecords[$cnt]['fuelcost'];
                        $totalspare=$totalspare+$fuelrecords[$cnt]['sparecost'];
                        $totalince=$totalince+$fuelrecords[$cnt]['incecost'];
                        $totalincome=$totalincome+$fuelrecords[$cnt]['income'];
                        
                        $cnt++;
                        
                    }
                    
                    if ($fuelaverage !=null and $fuelrecords != null) array_multisort($fuelaverage,SORT_DESC,$fuelrecords);
                    $summary['trucks']=count($trucks); $summary['totalfuel']= $totalfuel; $summary['totalspare']=$totalspare; $summary['totalincentive']=$totalince; $summary['totalincome']=$totalincome; 
                }
                
                $data = $this->renderPartial('_reportview',['datas'=>$fuelrecords,'from'=>$_POST['Movements']['from'],'to'=>$_POST['Movements']['to'],'summary'=>$summary]);
                
                $pdf = new Pdf([
                    'mode' => Pdf::MODE_CORE,
                    'format' => Pdf::FORMAT_A4,
                    'orientation' => Pdf::ORIENT_PORTRAIT,
                    'destination' => Pdf::DEST_BROWSER,
                    'content' => $data,
                    'cssFile' => '@vendor/kartik-v/yii2-mpdf/src/assets/kv-mpdf-bootstrap.min.css',
                    'cssInline' => '.kv-heading-1{font-size:18px}',
                    'options' => ['title' => 'Fuel report'],
                    'methods' => [
                        'SetFooter'=>['{PAGENO}'],
                    ]
                ]);
                
                return $pdf->render();
                
            }else{
                \Yii::$app->session->setFlash('error','From can not be greater than to');
            }
        }
        
        return $this->render('report', [
            'model' => $model,
        ]);
    }
}
