<?php

namespace app\controllers;

use Yii;
use app\models\Cars;
use app\models\Cartype;
use app\models\Defectivetrucks;
use app\models\DefectivetrucksSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use kartik\mpdf\Pdf;

/**
 * DefectivetrucksController implements the CRUD actions for Defectivetrucks model.
 */
class DefectivetrucksController extends Controller
{
    public function init() {
        $this->layout = 'workshop';
    }
    
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Defectivetrucks models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new DefectivetrucksSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Defectivetrucks model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Defectivetrucks model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Defectivetrucks();

        if ($model->load(Yii::$app->request->post())) {
            $model->indate=date('Y-m-d',strtotime($model->indate));
            $model->outdate='0000-00-00';
             
                 if (Defectivetrucks::checkCarDublicate($model->carId)==null){
            if($model->save()){
                \Yii::$app->session->setFlash('success','Successfull saved new defected car');
                return $this->redirect(['index']);
            } 
                 }else {
                     \Yii::$app->session->setFlash('error','This car is still in the list of defective cars');
                     return $this->redirect(['index']);
                 }
            
        }
        
        if (\Yii::$app->request->isAjax){
            return $this->renderAjax('create', [
                'model' => $model,
            ]);
        }else{
            return $this->render('create', [
                'model' => $model,
            ]);
        }
    }
    
    public function actionRelease($id)
    {
        $model = Defectivetrucks::findOne($id);
        
        
        if ($model->load(Yii::$app->request->post())) {
            $model->outdate=date('Y-m-d',strtotime($model->outdate));
            
                if($model->save()){
                    \Yii::$app->session->setFlash('success','Successfull gatedout defected car');
                    return $this->redirect(['index']);
                }
            
        }
        
        $model->outdate=null;
        
        if (\Yii::$app->request->isAjax){
            return $this->renderAjax('release', [
                'model' => $model,
            ]);
        }else{
            return $this->render('release', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Updates an existing Defectivetrucks model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Defectivetrucks model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Defectivetrucks model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Defectivetrucks the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Defectivetrucks::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
    
    public function actionStatusreport()
    {

                $trucks=Cars::find()->where(['typeId' =>Cartype::getHorsesId(),'status'=>1,'company'=>\Yii::$app->session->get('company')])->orderBy(['typeId'=>SORT_DESC])->all();
                $defectivetrucks=array();
                $goodtrucks=array();
                $reasons=array();
                $cnt=0;
                $c=0;
                
                if ($trucks != null){
                    foreach ($trucks as $truck){
                        $check= Defectivetrucks::checkCarDublicate($truck->plateno);
                        
                        if ($check==null){
                            $goodtrucks[$cnt]['truck']=$truck->plateno;
                            $goodtrucks[$cnt]['type']=$truck->type->name;
                            $goodtrucks[$cnt]['status']='Good';
                            $cnt++;
                        }else{
                            $defectivetrucks[$c]['truck']=$truck->plateno;
                            $defectivetrucks[$c]['type']=$truck->type->name;
                            $defectivetrucks[$c]['status']='Broken';
                            foreach ($check as $ck){
                                $defectivetrucks[$c]['date']=date('d-m-Y',strtotime($ck->indate));
                                $defectivetrucks[$c]['reason']=$ck->reason;
                            }
                            $c++;
                        }
                    } 
                 }
                 
                 $data = $this->renderPartial('_statusreportview',['defectivetrucks'=>$defectivetrucks,'goodtrucks'=>$goodtrucks]);
                 
                 $pdf = new Pdf([
                     'mode' => Pdf::MODE_CORE,
                     'format' => Pdf::FORMAT_A4,
                     'orientation' => Pdf::ORIENT_PORTRAIT,
                     'destination' => Pdf::DEST_BROWSER,
                     'content' => $data,
                     'cssFile' => '@vendor/kartik-v/yii2-mpdf/src/assets/kv-mpdf-bootstrap.min.css',
                     'cssInline' => '.kv-heading-1{font-size:18px}',
                     'options' => ['title' => 'Workshop status report'],
                     'methods' => [
                         'SetFooter'=>['{PAGENO}'],
                     ]
                 ]);
                 
                 return $pdf->render();
        
    }
}
