<?php

namespace app\controllers;

use Yii;
use app\models\Billcontent;
use app\models\Cfbills;
use app\models\CfbillsSearch;
use app\models\Docsupload;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;

/**
 * CfbillsController implements the CRUD actions for Cfbills model.
 */
class CfbillsController extends Controller
{
    public function init() {
        $this->layout = 'cnf';
    }
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Cfbills models.
     * @return mixed
     */
    public function actionIndex()
    {
        if (\Yii::$app->session->get('fileId')!=null){
            $searchModel = new CfbillsSearch();
            $dataProvider = $searchModel->search(Yii::$app->request->queryParams);
    
            if (Docsupload::getDocumentById(1)==null){
                \Yii::$app->session->setFlash('error','Upload bill of lading, before requesting');
                return $this->redirect(['docsupload/index','id'=>\Yii::$app->session->get('fileId')]);
            }else{
            return $this->render('index', [
                'searchModel' => $searchModel,
                'dataProvider' => $dataProvider,
            ]);
            }
        }else{
            return $this->redirect(['uzers/dashboard']);
        }
    }

    /**
     * Displays a single Cfbills model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Cfbills model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Cfbills();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing Cfbills model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Cfbills model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $model = $this->findModel($id);
        
        if (Billcontent::getBillCost($model->billId)==0){
            \Yii::$app->session->setFlash('success','Successfull deleted a request');
        $this->findModel($id)->delete();
        }else{
            \Yii::$app->session->setFlash('error','The request has content, can not be deleted');
        }
        return $this->redirect(['index']);
    }

    /**
     * Finds the Cfbills model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Cfbills the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Cfbills::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
}
