<?php

namespace app\controllers;

use Yii;
use app\models\Bills;
use app\models\BillsSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use app\models\Billcontent;
use app\models\Wshopbills;
use app\models\Cfbills;

/**
 * BillsController implements the CRUD actions for Bills model.
 */
class BillsController extends Controller
{
    public function init() {
        $this->layout = 'accounts';
    }
    
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Bills models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new BillsSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    
    public function actionIndexpaid()
    {
        $searchModel = new BillsSearch();
        $dataProvider = $searchModel->searchpaid(Yii::$app->request->queryParams);
        
        return $this->render('indexpaid', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }
    /**
     * Displays a single Bills model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Bills model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Bills();

        if ($model->load(Yii::$app->request->post())) {
            
            $model->date=date('Y-m-d',strtotime($model->date));
            $model->dueDate=date('Y-m-d',strtotime($model->dueDate));
            $model->company=\Yii::$app->session->get('company');
            $model->userId=\Yii::$app->user->getId();
            
            if($model->save()){
            return $this->redirect(['billcontent/create', 'id' => $model->id]);
            }
        }
        
        if (\Yii::$app->request->isAjax){
            return $this->renderAjax('create', [
                'model' => $model,
            ]);
        }else{
            return $this->render('create', [
                'model' => $model,
            ]);
        }
    }
    
    
    public function actionCreateworkshop()
    {
        $this->layout='workshop';
        
        $model = new Bills();
        $wbills = new Wshopbills();
        
        if ($model->load(Yii::$app->request->post())) {
            
            $model->date=date('Y-m-d',strtotime($model->date));
            $model->dueDate=date('Y-m-d',strtotime($model->dueDate));
            $model->company=\Yii::$app->session->get('company');
            $model->userId=\Yii::$app->user->getId();
            
            if($model->save()){
                $wbills->billid=$model->id;
                $wbills->save();
                
                return $this->redirect(['billcontent/createworkshop', 'id' => $model->id]);
            }
        }
        
        if (\Yii::$app->request->isAjax){
            return $this->renderAjax('createworkshop', [
                'model' => $model,
            ]);
        }else{
            return $this->render('createworkshop', [
                'model' => $model,
            ]);
        }
    }
    
    
    public function actionCreateclearing()
    {
        $this->layout='cnf';
        
        $model = new Bills();
        $cbills = new Cfbills();
        
        if ($model->load(Yii::$app->request->post())) {
            
            $model->date=date('Y-m-d',strtotime($model->date));
            $model->dueDate=date('Y-m-d',strtotime($model->dueDate));
            $model->company=\Yii::$app->session->get('company');
            $model->userId=\Yii::$app->user->getId();
            
            if($model->save()){
                $cbills->billId=$model->id;
                $cbills->fileId=\Yii::$app->session->get('fileId');
                $cbills->save();
                
                return $this->redirect(['billcontent/createclearing', 'id' => $model->id]);
            }
        }
        
        if (\Yii::$app->request->isAjax){
            return $this->renderAjax('createclearing', [
                'model' => $model,
            ]);
        }else{
            return $this->render('createclearing', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Updates an existing Bills model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if (Billcontent::getBillCost($id)==0){
        if ($model->load(Yii::$app->request->post())) {
            if ($model->save()){
            return $this->redirect(['create', 'id' => $model->id]);
            }
        }
        }else{
            \Yii::$app->session->setFlash('error','This bill can not be edited it has contents');
            return $this->redirect(['index']);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Bills model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        if (Billcontent::getBillCost($id)==0){
        $this->findModel($id)->delete();
        \Yii::$app->session->setFlash('success','Bill successfull deleted ');
        return $this->redirect(['index']);
        }else{
            \Yii::$app->session->setFlash('error','This bill can not be deleted it has contents');
            return $this->redirect(['index']);
        }
        
       
    }

    /**
     * Finds the Bills model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Bills the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Bills::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
}
