<?php

namespace app\controllers;

use Yii;
use app\models\Billpayments;
use app\models\BillpaymentsSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use app\models\Bills;
use app\models\Billcontent;

/**
 * BillpaymentsController implements the CRUD actions for Billpayments model.
 */
class BillpaymentsController extends Controller
{
    public function init() {
        $this->layout = 'accounts';
    }
    
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Billpayments models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new BillpaymentsSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Billpayments model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Billpayments model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate($id)
    {
        $model = new Billpayments();

        if ($model->load(Yii::$app->request->post())) {
            
            $model->userId=\Yii::$app->user->getId();
            $model->company=\Yii::$app->session->get('company');
            $model->billId=$id;
            $model->date=date('Y-m-d');
            if ($model->amount<=Billcontent::getBillCost($id) && $model->amount>0){
            if($model->save()){
                $bill=Bills::findOne($id);
                $bill->paid=1;
                if ($bill->save()){
                    return $this->redirect(['bills/index']);
                }
            }
            }else{
                \Yii::$app->session->setFlash('error','Check the inserted payment amount');
            }
        }

        return $this->render('create', [
            'model' => $model,'id'=>$id,
        ]);
    }

    /**
     * Updates an existing Billpayments model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Billpayments model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Billpayments model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Billpayments the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Billpayments::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
}
