<?php

namespace app\controllers;

use Yii;
use app\models\Billcontent;
use app\models\BillcontentSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\data\ActiveDataProvider;
use app\models\Servicecost;
use app\models\Bills;
use app\models\Services;
use app\models\Accounts;
use kartik\mpdf\Pdf;

/**
 * BillcontentController implements the CRUD actions for Billcontent model.
 */
class BillcontentController extends Controller
{
    public function init() {
        $this->layout = 'accounts';
    }
    
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Billcontent models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new BillcontentSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Billcontent model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Billcontent model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate($id)
    {
        $fileId= \Yii::$app->session->get('fileId');
        if ($fileId != 0) $this->layout='cnf';
        
        $query = Billcontent::find();
        $query->andFilterWhere([
            'billId' => $id,
        ]);
        
        // add conditions that should always apply here
        
        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);
        
        $model = new Billcontent();

        if ($model->load(Yii::$app->request->post())) {
            
            $model->billId=$id;
            $contId=Billcontent::checkServiceInBill($model->serviceId,$id);
            
            if ($contId==null){
            if (Bills::findOne($id)->billby0->currency==Accounts::findOne(Services::findOne($model->serviceId)->purchaseaccId)->currency){
            if($model->save()){
            return $this->redirect(['create', 'id' => $id]);
            }
            }else{
                \Yii::$app->session->setFlash('error','Mis-matching currency between service and the bill');
                return $this->redirect(['create', 'id' => $id]);
            }
            }else{
                return $this->redirect(['update', 'id' => $contId]);
            }
        }

        return $this->render('create', [
            'model' => $model,'dataProvider'=>$dataProvider,'id'=>$id,
        ]);
    }
    
    public function actionCreateworkshop($id)
    {
        $this->layout='workshop';
        
        $query = Billcontent::find();
        $query->andFilterWhere([
            'billId' => $id,
        ]);
        
        // add conditions that should always apply here
        
        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);
        
        $model = new Billcontent();
        
        if ($model->load(Yii::$app->request->post())) {
            
            $model->billId=$id;
            $contId=Billcontent::checkServiceInBill($model->serviceId,$id);
            
            if ($contId==null){
                if (Bills::findOne($id)->billby0->currency==Accounts::findOne(Services::findOne($model->serviceId)->purchaseaccId)->currency){
                    if($model->save()){
                        return $this->redirect(['createworkshop', 'id' => $id]);
                    }
                }else{
                    \Yii::$app->session->setFlash('error','Mis-matching currency between service and the bill');
                    return $this->redirect(['createworkshop', 'id' => $id]);
                }
            }else{
                return $this->redirect(['update', 'id' => $contId]);
            }
        }
        
        return $this->render('createworkshop', [
            'model' => $model,'dataProvider'=>$dataProvider,'id'=>$id,
        ]);
    }
    
    
    public function actionCreateclearing($id)
    {
        $this->layout='cnf';
        
        $query = Billcontent::find();
        $query->andFilterWhere([
            'billId' => $id,
        ]);
        
        // add conditions that should always apply here
        
        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);
        
        $model = new Billcontent();
        
        if ($model->load(Yii::$app->request->post())) {
            
            $model->billId=$id;
            $contId=Billcontent::checkServiceInBill($model->serviceId,$id);
            
            if ($contId==null){
                if (Bills::findOne($id)->billby0->currency==Accounts::findOne(Services::findOne($model->serviceId)->purchaseaccId)->currency){
                    if($model->save()){
                        return $this->redirect(['createclearing', 'id' => $id]);
                    }
                }else{
                    \Yii::$app->session->setFlash('error','Mis-matching currency between service and the bill');
                    return $this->redirect(['createclearing', 'id' => $id]);
                }
            }else{
                return $this->redirect(['update', 'id' => $contId]);
            }
        }
        
        return $this->render('createclearing', [
            'model' => $model,'dataProvider'=>$dataProvider,'id'=>$id,
        ]);
    }
    
    
    public function actionCostcreate() {
        Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;
        if (isset($_POST['depdrop_parents'])) {
            $parents = $_POST['depdrop_parents'];
            if ($parents != null) {
                $cat_id = $_POST['depdrop_parents'];
                $out =[['id'=>Servicecost::getServiceCost($cat_id)->purchasecost, 'name'=>number_format(Servicecost::getServiceCost($cat_id)->purchasecost)]];
                return ['output'=>$out, 'selected'=>''];
            }
        }
        return ['output'=>'', 'selected'=>''];
    }

    /**
     * Updates an existing Billcontent model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {  
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post())) {
            
            if($model->save()){
                return $this->redirect(['create', 'id' => $model->billId]);
            }
        }

        return $this->render('update', [
            'model' => $model
        ]);
    }

    /**
     * Deletes an existing Billcontent model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $billId=Billcontent::findOne($id)->billId;
        $this->findModel($id)->delete();

        return $this->redirect(['create','id'=>$billId]);
    }

    /**
     * Finds the Billcontent model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Billcontent the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Billcontent::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
    
 
    
    public function actionPrintrequest($id) {
        
        $model= Bills::findOne($id);
        $contents=Billcontent::find()->where(['billId'=>$id])->all();
        $data = $this->renderPartial('_requestview',['model'=>$model,'contents'=>$contents]);
        
        $pdf = new Pdf([
            'mode' => Pdf::MODE_CORE,
            'format' => Pdf::FORMAT_A4,
            'orientation' => Pdf::ORIENT_PORTRAIT,
            'destination' => Pdf::DEST_BROWSER,
            'content' => $data,
            'cssFile' => '@vendor/kartik-v/yii2-mpdf/src/assets/kv-mpdf-bootstrap.min.css',
            'cssInline' => '.kv-heading-1{font-size:18px}',
            'options' => ['title' => 'Bills request'],
            'methods' => [
                'SetHeader'=>[''],
                'SetFooter'=>['{PAGENO}'],
            ]
        ]);
        
        return $pdf->render();
    }
    
    public function actionGetPrice($selected)
    {
        $service= Servicecost::find()->where(['serviceId'=>$selected,'status'=>1])->one();
        
        echo json_encode($service->purchasecost);
    }
}
