<?php

namespace app\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use app\models\Wshopbills;
use app\models\Bills;

/**
 * WshopbillsSearch represents the model behind the search form of `app\models\Wshopbills`.
 */
class WshopbillsSearch extends Wshopbills
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'billid', 'status'], 'integer'],
            [['numbername'], 'string', 'max' => 10],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Wshopbills::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'pagination' => [
                'pageSize' => 50,
            ],
            'sort'=> ['defaultOrder' => ['billid'=>SORT_DESC]]
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'billid' => $this->numbername!=null?Bills::reverseBillNo($this->numbername):$this->numbername,
            //'billid' => Bills::getBillsIdOfThisyear(),
            'status' => $this->status,
            'company'=>\Yii::$app->session->get('company'),
        ]);

        return $dataProvider;
    }
}
