<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "wshopbills".
 *
 * @property int $id
 * @property int $billid
 * @property int $status
 * @property int $accountId
 * @property string $amount
 * @property string $checkNo
 *
 * @property Bills $bill
 */
class Wshopbills extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public $accountId, $amount, $checkNo,$numbername, $date;
    
    public static function tableName()
    {
        return 'wshopbills';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['billid'], 'required'],
            [['billid', 'status'], 'integer'],
            [['billid'], 'exist', 'skipOnError' => true, 'targetClass' => Bills::className(), 'targetAttribute' => ['billid' => 'id']],
            [['date'], 'exist', 'skipOnError' => true, 'targetClass' => Bills::className(), 'targetAttribute' => ['date' => 'date']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'billid' => 'Bill #',
            'status' => 'Status',
            'accountId'=>'Account name',
            'amount'=>'Amount',
            'checkNo'=>'Check No',
            'numbername'=>'Bill #',
            'date'=>'Date',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getBill()
    {
        return $this->hasOne(Bills::className(), ['id' => 'billid']);
    }
}
