<?php

namespace app\models;

use Yii;
use phpDocumentor\Reflection\Types\Null_;

/**
 * This is the model class for table "trailers".
 *
 * @property int $id
 * @property string $horseid
 * @property string $trailerid
 * @property int $status
 * @property string $dateassigned
 *
 * @property Cars $horse
 * @property Cars $trailer
 */
class Trailers extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'trailers';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['horseid', 'trailerid', 'dateassigned'], 'required'],
            [['status'], 'integer'],
            [['dateassigned'], 'safe'],
            [['horseid', 'trailerid'], 'string', 'max' => 7],
            [['horseid'], 'exist', 'skipOnError' => true, 'targetClass' => Cars::className(), 'targetAttribute' => ['horseid' => 'plateno']],
            [['trailerid'], 'exist', 'skipOnError' => true, 'targetClass' => Cars::className(), 'targetAttribute' => ['trailerid' => 'plateno']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'horseid' => 'Horseid',
            'trailerid' => 'Trailer',
            'status' => 'Status',
            'dateassigned' => 'Dateassigned',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getHorse()
    {
        return $this->hasOne(Cars::className(), ['plateno' => 'horseid']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getTrailer()
    {
        return $this->hasOne(Cars::className(), ['plateno' => 'trailerid']);
    }
    
    public function deactivateActiveTrailer($hsId,$trId){
        $status= false;
        
        $trailers= Trailers::find()
                    ->where(['horseId'=>$hsId,'status'=>1])
                    ->all();
        
                    foreach ($trailers as $trailer){
                        if ($trailer->trailerid != $trId){
                            $trailer->status=0;
                            $trailer->save();
                            
                            $status=true;
                        }
                        
                    }
                  
        return $status;
    }
    
    public function getActiveTrailer($id){
        
        $atrailer='Non';
        
        $trailer= Trailers::find()
        ->where(['horseId'=>$id,'status'=>1])
        ->one();
         
        if ($trailer != null) $atrailer=$trailer->trailerid;
        
        return $atrailer;
    }
}