<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "trafficoffences".
 *
 * @property int $id
 * @property int $type
 * @property int $responsible
 * @property string $carId
 * @property int $driverId
 * @property int $Amount
 * @property int $span
 * @property string $ref
 * @property string $location
 * @property string $officer
 * @property string $reason
 * @property string $paiddate
 * @property string $offencedate
 */
class Trafficoffences extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public $from, $to; 
    public static function tableName()
    {
        return 'trafficoffences';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['responsible', 'carId', 'driverId', 'Amount', 'ref', 'location', 'officer', 'reason', 'offencedate'], 'required'],
            [['responsible', 'driverId','type', 'Amount','span'], 'integer'],
            [['paiddate', 'offencedate'], 'safe'],
            [['carId'], 'string', 'max' => 7],
            [['ref', 'location', 'officer'], 'string', 'max' => 35],
            [['reason'], 'string', 'max' => 100],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'responsible' => 'Responsible',
            'carId' => 'Car',
            'driverId' => 'Driver',
            'Amount' => 'Amount',
            'ref' => 'Reference',
            'location' => 'Location',
            'officer' => 'Officer',
            'reason' => 'Reason',
            'paiddate' => 'Paiddate',
            'offencedate' => 'Offencedate',
            'type'=>'Dept type',
            'span'=>'Payment span',
        ];
    }
    
    public function checkDublicate($id){
        $ret=null;
        
        $offence= Trafficoffences::find()
        ->where(['ref'=>$id])
        ->all();
        
        if ($offence != null) {
            foreach ($offence as $of){
                $ret=$of->id;
            }
        }
        
        return $ret;
    }
    
    public function getResponsible($id){
        if ($id==1) return 'Company';
        elseif ($id==2) return 'Driver';
    }
    
    public function calculateCost($ofDate,$pdDate,$amount){
        
        $d1=date_create($ofDate);
        $d2= $pdDate !='0000-00-00'?date_create($pdDate):date_create(date('Y-m-d'));
        
        $interval=date_diff($d1,$d2);
        
        $days=$interval->format('%a');
        $av=intval($days/7);
        
        if($av<=4) return $amount+7500*$av;
        elseif ($av>4) return $amount+7500*4;
        
    }
    
    public function calculateDriverCost($driverId,$from,$to){
        
        $offences= Trafficoffences::find()
        ->where("responsible=2 and driverId='$driverId' and offencedate > '$from' and offencedate < '$to' and type=1")->all();
        $total=0;
        
        if ($offences !=null){
            foreach ($offences as $offence){
                $d1=date_create($offence->offencedate);
                $d2= $offence->paiddate != null?date_create($offence->paiddate):date_create(date('Y-m-d'));
                
                $interval=date_diff($d1,$d2);
                
                $days=$interval->format('%a');
                $av=intval($days/7);
                
                //if($av<=4) $total=$offence->Amount+7500*$av;
                //elseif ($av>4) $total=$offence->Amount+7500*4;
                
                $total=$offence->Amount;
            }
        }
        
        return $total;
    }
    
    
    public function calculateDriverOtherCost($driverId,$ince,$dat){
        
        $dt=date('Y-m-d',strtotime($dat));
        $offences= Trafficoffences::find()
        ->where("responsible=2 and driverId='$driverId' and type!=1 and paiddate >= '$dt'")->all();
        $monthtotal=0;
        
        if ($offences !=null){
            foreach ($offences as $offence){
                 $paids=Offencepayments::find()->where("offenceid='$offence->id'")->all();
                 if($paids != null){
                     foreach($paids as $pds){
                         $cmpn=Cars::findOne($offence->carId)->company;
                         if(date('m-Y',strtotime($pds->date)) == date('m-Y') and (\Yii::$app->session->get('company')==$cmpn)){
                             
                             if($monthtotal >= $ince){
                                 $updatepay= Offencepayments::findOne($pds->id);
                                 $updatepay->date=date('Y-m-d',strtotime('+1 month'));
                                 $updatepay->save();  
                             }else{
                                $monthtotal=$monthtotal+$pds->amount; 
                             }
                         }
                     }
                 }
            } 
        }

        
        return $monthtotal;
    }
    
    public function calculateCarCost($carId,$from,$to){
        
        $offences= Trafficoffences::find()
        ->where("carId='$carId' and offencedate > '$from' and offencedate < '$to'")->all();
        $total=0;
        
        if ($offences !=null){
            foreach ($offences as $offence){
                $d1=date_create($offence->offencedate);
                $d2= $offence->paiddate != null?date_create($offence->paiddate):date_create(date('Y-m-d'));
                
                $interval=date_diff($d1,$d2);
                
                $days=$interval->format('%a');
                $av=intval($days/7);
                
                if($av<=4) $total=$offence->Amount+7500*$av;
                elseif ($av>4) $total=$offence->Amount+7500*4;
            }
        }
        
        return $total;
    }
    
    
        
    public function getdatediffindays($date){
        
        $ret=null;
        
        $d1= date_create(date('Y-m-d'));
        $d2= date_create($date);
        
        $interval=date_diff($d1,$d2);
        
        $ret=$interval->format('%a');
        
        return $ret;
    }
    
    
}
