<?php

namespace app\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use app\models\Tirestore;

/**
 * TirestoreSearch represents the model behind the search form of `app\models\Tirestore`.
 */
class TirestoreSearch extends Tirestore
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'size', 'type'], 'integer'],
            [['regnumber', 'expdate', 'receiveddate','brandname'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Tirestore::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'status'=>[1,2,3,4,5],
            'size' => $this->size,
            'expdate' => $this->expdate,
            'receiveddate' => $this->receiveddate,
            'type' => $this->type,
            'brandname'=>$this->brandname,
        ]);

        $query->andFilterWhere(['like', 'regnumber', $this->regnumber]);

        return $dataProvider;
    }
}
