<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "tirestore".
 *
 * @property int $id
 * @property string $regnumber
 * @property string $size
 * @property string $expdate
 * @property string $receiveddate
 * @property int $type
 * @property int $category
 * @property int $brandname
 * @property int $status
 *
 * @property Tireallocation[] $tireallocations
 */
class Tirestore extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'tirestore';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['regnumber', 'size', 'expdate', 'receiveddate', 'type', 'brandname', 'status','category'], 'required'],
            [['expdate', 'receiveddate'], 'safe'],
            [['regnumber','size'], 'string', 'max' => 20],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'regnumber' => 'Reference #',
            'size' => 'Size',
            'expdate' => 'Date',
            'receiveddate' => 'Receiveddate',
            'type' => 'Tire type',
            'brandname' => 'Brand',
            'status' => 'Status',
            'category'=>'Group type', 
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getTireallocations()
    {
        return $this->hasMany(Tireallocation::className(), ['storeId' => 'id']);
    }

    
    public function getTireType($id){
        
        if ($id==1) return 'Front';
        elseif ($id==2) return 'Deef';
        elseif ($id==3) return 'Back';
        elseif ($id==4) return 'All position';
    }
    
     public function getTireCategory($id){
        
        if ($id==1) return 'Brand New';
        elseif ($id==2) return 'Retread';
        elseif ($id==3) return 'Good';
        elseif ($id==4) return 'Intermidiate';
        elseif ($id==5) return 'Wareout';
        elseif ($id==0) return 'Removed';
        
    }
}
