<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "tireservices".
 *
 * @property int $id
 * @property string $truckId
 * @property int $driverId
 * @property string $servicedate
 * @property string $recorddate
 * @property string $priceperservice
 * @property int $byy
 *
 * @property Cardrivers $driver
 * @property Cars $truck
 */
class Tireservices extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    
    public $from, $to;
    
    public static function tableName()
    {
        return 'tireservices';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['truckId', 'driverId', 'servicedate', 'recorddate', 'priceperservice', 'byy'], 'required'],
            [['driverId', 'byy'], 'integer'],
            [['servicedate', 'recorddate'], 'safe'],
            [['priceperservice'], 'number'],
            [['truckId'], 'string', 'max' => 7],
            [['driverId'], 'exist', 'skipOnError' => true, 'targetClass' => Cardrivers::className(), 'targetAttribute' => ['driverId' => 'id']],
            [['truckId'], 'exist', 'skipOnError' => true, 'targetClass' => Cars::className(), 'targetAttribute' => ['truckId' => 'plateno']],
            ['servicedate', 'compare', 'compareValue' => date('Y-m-d'), 'operator' => '<=','message'=>"Date can not be above today" ],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'truckId' => 'Truck',
            'driverId' => 'Driver',
            'servicedate' => 'Service date',
            'recorddate' => 'Recorded date',
            'priceperservice' => 'Service price',
            'byy' => 'Byy',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getDriver()
    {
        return $this->hasOne(Cardrivers::className(), ['id' => 'driverId']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getTruck()
    {
        return $this->hasOne(Cars::className(), ['plateno' => 'truckId']);
    }
}
