<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "tireallocation".
 *
 * @property int $id
 * @property int $storeId
 * @property int $status
 * @property string $carId
 * @property string $date
 *
 * @property Cars $car
 * @property Tirestore $store
 */
class Tireallocation extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'tireallocation';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['storeId', 'carId', 'date'], 'required'],
            [['storeId','status'], 'integer'],
            [['date'], 'safe'],
            [['carId'], 'string', 'max' => 7],
            [['carId'], 'exist', 'skipOnError' => true, 'targetClass' => Cars::className(), 'targetAttribute' => ['carId' => 'plateno']],
            [['storeId'], 'exist', 'skipOnError' => true, 'targetClass' => Tirestore::className(), 'targetAttribute' => ['storeId' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'storeId' => 'Tires',
            'carId' => 'Truck #',
            'date' => 'Date',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getCar()
    {
        return $this->hasOne(Cars::className(), ['plateno' => 'carId']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getStore()
    {
        return $this->hasOne(Tirestore::className(), ['id' => 'storeId']);
    }

 
}
