<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "techassign".
 *
 * @property int $id
 * @property int $defectiveId
 * @property int $userId
 * @property string $date
 *
 * @property Defectivetrucks $defective
 * @property Uzers $user
 */
class Techassign extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'techassign';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['defectiveId', 'userId', 'date'], 'required'],
            [['defectiveId', 'userId'], 'integer'],
            [['date'], 'safe'],
            [['defectiveId'], 'exist', 'skipOnError' => true, 'targetClass' => Defectivetrucks::className(), 'targetAttribute' => ['defectiveId' => 'id']],
            [['userId'], 'exist', 'skipOnError' => true, 'targetClass' => Uzers::className(), 'targetAttribute' => ['userId' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'defectiveId' => 'Defective ID',
            'userId' => 'Select technician',
            'date' => 'Date',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getDefective()
    {
        return $this->hasOne(Defectivetrucks::className(), ['id' => 'defectiveId']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getUser()
    {
        return $this->hasOne(Uzers::className(), ['id' => 'userId']);
    }
}
