<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "statistics".
 *
 * @property int $id
 * @property int $movetype
 * @property int $quantity
 * @property string $date
 * @property int $driver
 * @property string $truckId
 * @property int $size
 * @property string $onn
 *
 * @property Cardrivers $driver0
 * @property Movetype $movetype0
 * @property Cars $truck
 */
class Statistics extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public $from, $to;
    public static function tableName()
    {
        return 'statistics';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['movetype', 'quantity', 'date', 'driver', 'truckId', 'size','onn'], 'required'],
            [['movetype', 'quantity', 'driver', 'size'], 'integer'],
            [['date'], 'safe'],
            [['truckId'], 'string', 'max' => 7],
            [['driver'], 'exist', 'skipOnError' => true, 'targetClass' => Cardrivers::className(), 'targetAttribute' => ['driver' => 'id']],
            [['truckId'], 'exist', 'skipOnError' => true, 'targetClass' => Cars::className(), 'targetAttribute' => ['truckId' => 'plateno']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'movetype' => 'Type',
            'quantity' => 'Quantity(Units)',
            'date' => 'Date',
            'driver' => 'Driver',
            'truckId' => 'Truck',
            'size' => 'Size',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getDriver0()
    {
        return $this->hasOne(Cardrivers::className(), ['id' => 'driver']);
    }


    /**
     * @return \yii\db\ActiveQuery
     */
    public function getTruck()
    {
        return $this->hasOne(Cars::className(), ['plateno' => 'truckId']);
    }
    
    public function getTruckTodayStatistics($id){
        
        return Statistics::find()->where(['truckId'=>$id, 'onn'=>date('Y-m-d')])->all();
    }
    
    public function getTruckStatisticsByTime($id,$from,$to){
        
        $stats= Statistics::find()
        ->where("date >= '$from' and date <= '$to' and truckId='$id'")
        ->all();
        
        return $stats;
    }
    
  public function getTruckStatisticsByTimeMoveSize($id,$type,$size,$from,$to){
        $c=0;
        $stats= Statistics::find()
        ->where("date >= '$from' and date <= '$to' and truckId='$id' and movetype='$type' and size='$size'")
        ->all();
        
        if ($stats != null) {
            foreach ($stats as $stat){
                $c= $c + $stat->quantity;
            }
        }
        
        return $c;
    }
    
    public function checkDublicate($id,$type,$size,$dt){
        
        return Statistics::find()->where(['truckId'=>$id, 'date'=>$dt,'movetype'=>$type,'size'=>$size])->all();
    }
    
    public function getExpectedIncome($tId,$size,$cr){
        $ret=0;
        $mtype= Movetype::findOne($tId);
        
        if ($mtype != null and $mtype->currency==$cr){
            if ($size==2) $ret=$mtype->twentypay;
            elseif ($size==4) $ret=$mtype->fortypay;
            else $ret=$mtype->otherpay;
        }
        
        return $ret;
    }
    
    public function getTruckExpectedIncomeByTime($id,$from,$to,$cr){
        $total=0;
        
        $stats= Statistics::find()
        ->where("date >= '$from' and date <= '$to' and truckId='$id'")
        ->all();
        
        if ($stats != null){
            foreach ($stats as $stat){
                $total=$total+ Statistics::getExpectedIncome($stat->movetype,$stat->size,$cr)*$stat->quantity;
            }
        }
        return $total;
    }
    
    public function getQuantityOfTrucksInvolved($id,$from,$to){
        $quantity=0;
        
        $trucks= Cars::find()->where(['typeId' =>Cartype::getHorsesId(),'status'=>1,'company'=>\Yii::$app->session->get('company')])-> all();
        
        if ($trucks != null){
            foreach ($trucks as $truck){
                $stats= Statistics::find()
                ->where("date >= '$from' and date <= '$to' and movetype='$id' and truckId='$truck->plateno'")
                ->all();
                
                if ($stats != null){
                    $quantity++;
                }
            }
        }
        
        return $quantity;
    }
    
    public function getExpectedIncomeByMove($id,$from,$to,$cr){
        $total=0;
        
        $stats= Statistics::find()
        ->where("date >= '$from' and date <= '$to' and movetype='$id'")
        ->all();
        
        if ($stats != null){
            foreach ($stats as $stat){
                if (Cars::findOne($stat->truckId)->company==\Yii::$app->session->get('company')){
                    $total=$total+Statistics::getExpectedIncome($stat->movetype,$stat->size,$cr)*$stat->quantity;
                }
            }
        }
        
        return $total;
    }
    
    public function getExpectedQuantityByMoveandSize($id,$size,$from,$to){
        $quantity=0;
        
        $stats= Statistics::find()
        ->where("date >= '$from' and date <= '$to' and movetype='$id' and size='$size'")
        ->all();
        
        if ($stats != null){
            foreach ($stats as $stat){
                if (Cars::findOne($stat->truckId)->company==\Yii::$app->session->get('company')){
                $quantity=$quantity+ $stat->quantity;
                }
            }
        }
        return $quantity;
    }
    
    public function getExpectedTripByMoveandTruck($id,$truck,$from,$to){
        $trp=0;
        $prevdate=null;
        $f=date('Y-m-d',strtotime($from));
        $t=date('Y-m-d',strtotime($to));
        
        
        $stats= Statistics::find()
        ->where("date >= '$from' and date <= '$to' and movetype='$id' and truckId='$truck'")
        ->orderBy(['date'=>SORT_DESC])->all();
        
        if ($stats != null){
            foreach ($stats as $stat){
            
            if ($stat->movetype0->triptype!=2) $div=2; else $div=1;
            
                    if (($prevdate==null) and ($stat->size==2)){
                        $c=0;
                        $dayMoves= Statistics::find()
                        ->where(['movetype'=>$id,'size'=>2,'date'=>$stat->date,'truckId'=>$truck])
                        ->all();
                        
                        if ($dayMoves!=null){
                            foreach ($dayMoves as $move){
                                 $c=$c+round($move->quantity/$div);
                            }
                        }
                        $trp=$trp+$c;
                        $prevdate=$stat->date;
                        
                    }elseif (($prevdate!=$stat->date) and ($stat->size==2)){
                        $c=0;
                        $dayMoves= Statistics::find()
                        ->where(['movetype'=>$id,'size'=>2,'date'=>$stat->date,'truckId'=>$truck])
                        ->all();
                        
                        if ($dayMoves!=null){
                            foreach ($dayMoves as $move){
                                $c=$c+round($move->quantity/$div);
                            }
                        }
                        
                        $trp=$trp+$c;
                        $prevdate=$stat->date;
                        
                    }elseif ($stat->size!=2){
                        $c=0;
                        $c=$c+$stat->quantity;
                       $trp=$trp+$c;
                    }
            }
        }
        return $trp;
    }
    
}