<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "services".
 *
 * @property int $id
 * @property string $name
 * @property string $description
 * @property int $company
 * @property int $status
 * @property string $date
 * @property int $saleaccId
 * @property int $purchaseaccId
 *
 * @property Servicecost[] $servicecosts
 */
class Services extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public $purchasecost, $saleprice, $from, $to;
    public static function tableName()
    {
        return 'services';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['name', 'description', 'company', 'date','currency'], 'required'],
            [['company', 'status', 'currency'], 'integer'],
            [['date'], 'safe'],
            [['name'], 'string', 'max' => 50],
            [['description'], 'string', 'max' => 150],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'name' => 'Name',
            'description' => 'Description',
            'company' => 'Company',
            'status' => 'Status',
            'date' => 'Date',
            'purchasecost'=>'Purchase cost',
            'saleprice'=>'Sale price',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getServicecosts()
    {
        return $this->hasMany(Servicecost::className(), ['serviceId' => 'id']);
    }
    
    public function getServiceByNameOld($name,$curr){
        
        $services= Services::find()->where(['like', 'name' , $name])->orderBy(['id'=>'SORT_DESC'])->all();
        $return=null;
        
        if ($services != null){
            foreach ($services as $service){
                    if ($service->currency==$curr){
                    $return=$service;
                    break;
                }
            }
        }
        
        return $return;
    }
    
    
        public function getServiceByName($name,$curr){
        
        $services1= Services::find()->where(['name'=>$name])->orderBy(['id'=>SORT_DESC])->all();
          $return=null;
                if ($services1== null){
                
                
                $services= Services::find()->where(['like', 'name' , $name])->orderBy(['id'=>SORT_DESC])->all();
              
                
                if ($services != null){
                    foreach ($services as $service){
                            if ($service->currency==$curr){
                            $return=$service;
                            break;
                        }
                    }
                }
     }else{
        
         foreach ($services1 as $service){
             if ($service->currency==$curr){
                 $return=$service;
                 break;
             }
         }
         
     }
        
        return $return;
    }
    
        public function getServiceByNameAllcurrency($name){
        
        $services1= Services::find()->where(['name'=>$name])->orderBy(['id'=>SORT_DESC])->all();
        $return=null;
        if ($services1== null){
            
            
            $services= Services::find()->where(['like', 'name' , $name])->orderBy(['id'=>SORT_DESC])->all();
            
            
            if ($services != null){
                foreach ($services as $service){
                        $return=$service;
                        break;
                }
            }
        }else{
            
            foreach ($services1 as $service){
                    $return=$service;
                    break;
            }
            
        }
        
        return $return;
    }
    
        public function getExactlyServiceByName($name,$curr){
        
        $services= Services::find()->where(['name'=>$name])->all();
        $return=null;
        
        if ($services != null){
            foreach ($services as $service){
                    if ($service->currency==$curr){
                    $return=$service;
                    break;
                }
            }
        }
        
        return $return;
    }
    
        
    public function getServiceIdByName($name){
        
        
        $services= Services::find()
        ->where(['LIKE',strtolower('name'),$name])
        ->all();
        
        $ids=null;
        
        if ($services != null){
            foreach ($services as $service){
                $ids[]=$service->id;
            }
        }
        
        return $ids;
    }
    
    
    

}