<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "servicecost".
 *
 * @property int $id
 * @property string $saleamount
 * @property string $purchasecost
 * @property int $serviceId
 * @property string $onn
 * @property int $byy
 * @property int $status
 *
 * @property Billcontent[] $billcontents
 * @property Invcontent[] $invcontents
 * @property Services $service
 */
class Servicecost extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'servicecost';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['serviceId', 'onn','byy'], 'required'],
            [['saleamount', 'purchasecost'], 'number'],
            [['serviceId', 'byy', 'status'], 'integer'],
            [['onn'], 'safe'],
            [['serviceId'], 'exist', 'skipOnError' => true, 'targetClass' => Services::className(), 'targetAttribute' => ['serviceId' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'saleamount' => 'Sale price',
            'purchasecost' => 'Purchase cost',
            'serviceId' => 'Service',
            'onn' => 'Onn',
            'byy' => 'Byy',
            'status' => 'Status',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getBillcontents()
    {
        return $this->hasMany(Billcontent::className(), ['serviceId' => 'id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getInvcontents()
    {
        return $this->hasMany(Invcontent::className(), ['serviceId' => 'id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getService()
    {
        return $this->hasOne(Services::className(), ['id' => 'serviceId']);
    }
    
    public function getServiceCost($id){
        
        return Servicecost::find()->where(['status'=>1,'serviceId'=>$id])->one();
    }
}
