<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "salaries".
 *
 * @property int $id
 * @property int $userId
 * @property string $amount
 * @property string $date
 * @property string bankacc
 * @property string ssfacc
 *
 * @property Deductions[] $deductions
 * @property Overtime[] $overtimes
 * @property Uzers $user
 */
class Salaries extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public $reqdate,$type;
    
    public static function tableName()
    {
        return 'salaries';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['userId'], 'required'],
            [['userId'], 'integer'],
            [['amount'], 'number'],
            [['date','bankacc','ssfacc','amount'], 'safe'],
            [['userId'], 'exist', 'skipOnError' => true, 'targetClass' => Uzers::className(), 'targetAttribute' => ['userId' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'userId' => 'User ID',
            'amount' => 'Amount',
            'bankacc'=>'Bank acc #',
            'ssfacc'=>'Social security #',
            'date' => 'Date',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getDeductions()
    {
        return $this->hasMany(Deductions::className(), ['salaryId' => 'id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getOvertimes()
    {
        return $this->hasMany(Overtime::className(), ['salaryId' => 'id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getUser()
    {
        return $this->hasOne(Uzers::className(), ['id' => 'userId']);
    }
    
    public function getUserSalary($id){
        $ret=null;
        $ret = Salaries::find()->where(['userId'=>$id])->orderBy(['id'=>SORT_DESC])->one();
        return $ret;
    }
    
    public function checkDublicate($id,$amount,$bacc, $ssacc){
        
        $salary= Salaries::find()->where(['userId'=>$id,'amount'=>$amount,'bankacc'=>$bacc,'ssfacc'=>$ssacc])->all();
        
        return $salary;
    }
    
    public function payeCalculator($p){
        $r=0;
        if ($p<=170000){
            $r=0;
        }elseif (($p<=360000)and($p>170000)){
            $r=($p-170000)*0.09;
            
        }elseif (($p<=540000)and($p>360000)){
            $r=((($p-360000)*0.2)+17100);
            
        }elseif (($p<=720000)and($p>540000)){
            $r=((($p-540000)*0.25)+53100);
            
        }elseif ($p>720000){
            $r=((($p-720000)*0.3)+98100);
            
        }
        
        return $r;
    }
}
