<?php

namespace app\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use app\models\Rfqcontent;

/**
 * RfqcontentSearch represents the model behind the search form of `app\models\Rfqcontent`.
 */
class RfqcontentSearch extends Rfqcontent
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'serviceId', 'count'], 'integer'],
            [['carId','date'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Rfqcontent::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'pagination' => [
                'pageSize' => 50,
            ],
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'date' => $this->date,
            'serviceId' => $this->serviceId,
            'count' => $this->count,
        ]);

        $query->andFilterWhere(['like', 'carId', $this->carId]);

        return $dataProvider;
    }
}
