<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "rfqcontent".
 *
 * @property int $id
 * @property int $serviceId
 * @property int $count
 * @property int $status
 * @property string $carId
 * @property string $date
 *
 * @property Rfq $rfq
 * @property Services $service
 */
class Rfqcontent extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'rfqcontent';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['serviceId', 'count'], 'required'],
            [['serviceId', 'count'], 'integer'],
            [['date'], 'safe'],
            [['carId'], 'string', 'max' => 7],
            [['id'], 'unique'],
            [['serviceId'], 'exist', 'skipOnError' => true, 'targetClass' => Services::className(), 'targetAttribute' => ['serviceId' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'serviceId' => 'Service',
            'count' => 'Quantity',
            'carId' => 'Truck',
            'date'=>'Date',
        ];
    }


    /**
     * @return \yii\db\ActiveQuery
     */
    public function getService()
    {
        return $this->hasOne(Services::className(), ['id' => 'serviceId']);
    }
    
    
    public function checkServiceInRfq($servid,$car){
        
        $ret=null;
        
        $contents=Rfqcontent::find()->where(['status'=>1,'serviceId'=>$servid,'carId'=>$car])->all();
        
        if ($contents != null){
            foreach ($contents as $content){
                $ret=$content->id;
            }
        }
        return $ret;
    }
    
}