<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "rfq".
 *
 * @property int $id
 * @property int $billby
 * @property string $date
 * @property int $userId
 * @property string $dueDate
 * @property int $paid
 * @property int $company
 * @property int $currency
 * @property int $paytype
 *
 * @property Accounts $billby0
 * @property Uzers $user
 * @property Rfqcontent[] $rfqcontents
 */
class Rfq extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'rfq';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['billby', 'date', 'userId', 'dueDate'], 'required'],
            [['billby', 'userId', 'paid', 'company', 'currency', 'paytype'], 'integer'],
            [['date', 'dueDate'], 'safe'],
            [['id'], 'unique'],
            [['billby'], 'exist', 'skipOnError' => true, 'targetClass' => Accounts::className(), 'targetAttribute' => ['billby' => 'id']],
            [['userId'], 'exist', 'skipOnError' => true, 'targetClass' => Uzers::className(), 'targetAttribute' => ['userId' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'Rfq #',
            'billby' => 'Bills by',
            'date' => 'Date',
            'userId' => 'User ID',
            'dueDate' => 'Due Date',
            'paid' => 'Paid',
            'company' => 'Company',
            'currency' => 'Currency',
            'paytype' => 'Paytype',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getBillby0()
    {
        return $this->hasOne(Accounts::className(), ['id' => 'billby']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getUser()
    {
        return $this->hasOne(Uzers::className(), ['id' => 'userId']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getRfqcontents()
    {
        return $this->hasMany(Rfqcontent::className(), ['rfqId' => 'id']);
    }
}
