<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "offuels".
 *
 * @property int $id
 * @property string $truckId
 * @property int $driverId
 * @property string $amount
 * @property string $date
 * @property int $fuelId
 * @property string $reasons
 *
 * @property Cardrivers $driver
 * @property Fuelrequest $fuel
 * @property Cars $truck
 */
class Offuels extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public $from, $to;
    public static function tableName()
    {
        return 'offuels';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['truckId', 'driverId', 'amount', 'date', 'fuelId', 'reasons'], 'required'],
            [['driverId', 'fuelId'], 'integer'],
            [['amount'], 'number'],
            [['date'], 'safe'],
            [['truckId'], 'string', 'max' => 7],
            [['reasons'], 'string', 'max' => 150],
            [['driverId'], 'exist', 'skipOnError' => true, 'targetClass' => Cardrivers::className(), 'targetAttribute' => ['driverId' => 'id']],
            [['fuelId'], 'exist', 'skipOnError' => true, 'targetClass' => Fuelrequest::className(), 'targetAttribute' => ['fuelId' => 'id']],
            [['truckId'], 'exist', 'skipOnError' => true, 'targetClass' => Cars::className(), 'targetAttribute' => ['truckId' => 'plateno']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'truckId' => 'Truck',
            'driverId' => 'Driver',
            'amount' => 'Amount(lts)',
            'date' => 'Date',
            'fuelId' => 'Fuel ID',
            'reasons' => 'Reasons',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getDriver()
    {
        return $this->hasOne(Cardrivers::className(), ['id' => 'driverId']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getFuel()
    {
        return $this->hasOne(Fuelrequest::className(), ['id' => 'fuelId']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getTruck()
    {
        return $this->hasOne(Cars::className(), ['plateno' => 'truckId']);
    }
    
    public function getConsumedfuels($id){
        $total=0;
        
        $offs= Offuels::find()->where(['fuelId'=>$id])->all();
        
        if ($offs != null){
            foreach ($offs as $off){ 
                $total=$total+$off->amount;
            }
        }
        
        return $total;
    }
    
    public function getConsumedfuelsByTruckInTime($id,$f,$t){
        $total=0;
        
        $offs= Offuels::find()->where("date >= '$f' and date <= '$t' and truckId='$id'")->all();
        
        if ($offs != null){
            foreach ($offs as $off){
                $total=$total+$off->amount;
            }
        }
        
        return $total;
    }
    
}
