<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "offencepayments".
 *
 * @property int $id
 * @property int $offenceid
 * @property string $date
 * @property int $amount
 *
 * @property Trafficoffences $offence
 */
class Offencepayments extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'offencepayments';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['offenceid', 'date', 'amount'], 'required'],
            [['offenceid', 'amount'], 'integer'],
            [['date'], 'safe'],
            [['id'], 'unique'],
            [['offenceid'], 'exist', 'skipOnError' => true, 'targetClass' => Trafficoffences::className(), 'targetAttribute' => ['offenceid' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'offenceid' => 'Offenceid',
            'date' => 'Date',
            'amount' => 'Amount',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getOffence()
    {
        return $this->hasOne(Trafficoffences::className(), ['id' => 'offenceid']);
    }
    
    public function paymentbyoffence($id){
        $pays= Offencepayments::find()->where("offenceid='$id'")->all();
        $total=0;
        
        if($pays != null){
            foreach($pays as $pay){
                $total=$total + $pay->amount; 
            }
        }
        
        return $total;
    }
    
    
        public function paymentbyoffencethismonth($id){
        $pays= Offencepayments::find()->where("offenceid='$id'")->all();
        $total=0;
        
        if($pays != null){
            foreach($pays as $pay){
                if(date('Y-m',strtotime($pay->date))==date('Y-m')){
                $total=$total + $pay->amount; 
                }
            }
        }
        
        return $total;
    }
}
