<?php

namespace app\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use app\models\Movetype;

/**
 * MovetypeSearch represents the model behind the search form of `app\models\Movetype`.
 */
class MovetypeSearch extends Movetype
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'triptype'], 'integer'],
            [['name'], 'safe'],
            [['incentive', 'twentypay', 'fortypay', 'otherpay'], 'number'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Movetype::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'pagination' => array('pageSize' => 50),
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'triptype' => $this->triptype,
            'incentive' => $this->incentive,
            'twentypay' => $this->twentypay,
            'fortypay' => $this->fortypay,
            'otherpay' => $this->otherpay,
        ]);

        $query->andFilterWhere(['like', 'name', $this->name]);

        return $dataProvider;
    }
}
