<?php

namespace app\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use app\models\Movements;
use app\models\Cardrivers;

/**
 * MovementsSearch represents the model behind the search form of `app\models\Movements`.
 */
class MovementsSearch extends Movements
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            //[['id', 'clientId', 'movetypeId', 'truckId', 'driverId', 'shippingline', 'size', 'byy', 'fuelId'], 'integer'],
            [['interchangedate', 'registereddate', 'containerno','truckId',], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Movements::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
               'pagination' => [
                'pageSize' => 50,
            ],
            'sort'=> ['defaultOrder' => ['registereddate'=>SORT_DESC]]
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions   [Cardrivers::find()->where(['userId'=>385])->all()] Cardrivers::getUserDriverId(385)
        $query->andFilterWhere([
            'id' => $this->id,
            'clientId' => $this->clientId,
            'movetypeId' => $this->movetypeId,
            'truckId' => $this->truckId,
            'interchangedate' => $this->interchangedate==null?$this->interchangedate:date('Y-m-d',strtotime($this->interchangedate)),
            'registereddate' => $this->registereddate,
            'driverId' =>$this->driverId ,
            'shippingline' => $this->shippingline,
            'size' => $this->size,
            'byy' => $this->byy,
            'company'=>\Yii::$app->session->get('company'),
            'fuelId' => $this->fuelId,
        ]);

        $query->andFilterWhere(['like', 'containerno', $this->containerno]);

        return $dataProvider;
    }
}