<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "leaves".
 *
 * @property int $id
 * @property int $userId
 * @property string $startdate
 * @property string $enddate
 * @property string $reason
 */
class Leaves extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
     public $days;
     
     
    public static function tableName()
    {
        return 'leaves';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['userId', 'startdate', 'enddate', 'reason'], 'required'],
            [['userId'], 'integer'],
            [['startdate', 'enddate'], 'safe'],
            [['reason'], 'string', 'max' => 120],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'userId' => 'Staff',
            'startdate' => 'Startdate',
            'enddate' => 'Enddate',
            'reason' => 'Reason',
            'days'=>'Duration',
        ];
    }
}
