<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "invopayments".
 *
 * @property int $id
 * @property string $date
 * @property int $userId
 * @property int $acId
 * @property string $checkNo
 * @property string $amount
 * @property int $company
 *
 * @property Uzers $user
 * @property Accounts $ac
 * @property Invoices $inv
 */
class Invopayments extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'invopayments';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['date', 'userId', 'acId', 'checkNo', 'amount'], 'required'],
            [['userId', 'acId', 'company'], 'integer'],
            [['date'], 'safe'],
            [['amount'], 'number'],
            [['checkNo'], 'string', 'max' => 30],
            [['userId'], 'exist', 'skipOnError' => true, 'targetClass' => Uzers::className(), 'targetAttribute' => ['userId' => 'id']],
            [['acId'], 'exist', 'skipOnError' => true, 'targetClass' => Accounts::className(), 'targetAttribute' => ['acId' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'date' => 'Date',
            'userId' => 'User ID',
            'acId' => 'Payment to',
            'checkNo' => 'Check/TT No',
            'amount' => 'Amount',
            'company' => 'Company',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getUser()
    {
        return $this->hasOne(Uzers::className(), ['id' => 'userId']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getAc()
    {
        return $this->hasOne(Accounts::className(), ['id' => 'acId']);
    }

    
    public function getInvoicePaidAmount($id){
        $ret=0;
        
        $payments=Invopaymentcontent::find()->where(['invoid'=>$id])->all();
        
        if ($payments != null){
            foreach ($payments as $payment){
                $ret=$ret+$payment->amount;
            }
        }
        
        return $ret;
    }
    
}
