<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "invopaymentcontent".
 *
 * @property int $id
 * @property int $invopaymentid
 * @property int $invoid
 * @property string $amount
 *
 * @property Invoices $invo
 * @property Invopayments $invopayment
 */
class Invopaymentcontent extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'invopaymentcontent';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['invoid','amount'], 'required'],
            [['invopaymentid', 'invoid'], 'integer'],
            [['invoid'], 'exist', 'skipOnError' => true, 'targetClass' => Invoices::className(), 'targetAttribute' => ['invoid' => 'id']],
            [['invopaymentid'], 'exist', 'skipOnError' => true, 'targetClass' => Invopayments::className(), 'targetAttribute' => ['invopaymentid' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'invopaymentid' => 'Invopaymentid',
            'invoid' => 'Invoid',
            'amount'=>'Amount',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getInvo()
    {
        return $this->hasOne(Invoices::className(), ['id' => 'invoid']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getInvopayment()
    {
        return $this->hasOne(Invopayments::className(), ['id' => 'invopaymentid']);
    }
    
    public function getTotalAmountByPaymentId($id){
        
        $ret=0;
        
        $payments=Invopaymentcontent::find()->where(['invopaymentid'=>$id])->all();
        
        if ($payments != null){
            foreach ($payments as $payment){
                $ret=$ret+$payment->amount;
            }
        }
        
        return $ret;
        
    }
}
