<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "invonames".
 *
 * @property int $id
 * @property int $invoid
 * @property int $no
 * @property int $tax
 * @property string $nm
 * @property string $date
 *
 * @property Invoices $invo
 */
class Invonames extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'invonames';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['invoid', 'no', 'nm','company','fileId','tax','date'], 'required'],
            [['invoid', 'no','company','tax'], 'integer'],
            [['nm'], 'string', 'max' => 2],
            [['invoid'], 'exist', 'skipOnError' => true, 'targetClass' => Invoices::className(), 'targetAttribute' => ['invoid' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'invoid' => 'Invoid',
            'no' => 'No',
            'nm' => 'Nm',
            'date' => 'Date',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getInvo()
    {
        return $this->hasOne(Invoices::className(), ['id' => 'invoid']);
    }
    
    
    public function setInvoiceNo($invoId,$fileId,$c,$nm){
        
        $bycompany=Invonames::find()->where(['company'=>$c])->orderBy(['id'=>SORT_DESC])->all();
        
        if ($bycompany==null){
            $set=new Invonames();
            $set->invoid=$invoId;
            $set->no=1;
            $set->fileId=$fileId;
            $set->nm=$nm;
            $set->date=date('Y-m-d');
            $set->company=$c;
            $set->tax= Invoices::findOne($invoId)->tax;
            $set->save();
        }else{
            
            
            $bycompanytax=Invonames::find()->where(['company'=>$c,'tax'=>Invoices::findOne($invoId)->tax])->orderBy(['id'=>SORT_DESC])->all();
            
            $oldNo=0;
            if ($bycompanytax != null){
            foreach ($bycompanytax as $b){
            	if (date('Y',strtotime($b->date))==date('Y')){
                	if ($b->no > $oldNo) $oldNo=$b->no;
                    }
                }
            }
            
            foreach ($bycompany as $by){
               
               $checkInvoId=Invonames::find()->where(['invoid'=>$invoId])->one();
               $checkfileId=Invonames::find()->where(['fileId'=>$fileId])->one();
               if ($fileId==0){ 
                   if ($checkInvoId==null){
                       $set=new Invonames();
                       $set->invoid=$invoId;
                       $set->no=$oldNo+1;
                       $set->fileId=$fileId;
                       $set->nm=$nm;
                       $set->date=date('Y-m-d');
                       $set->company=$c;
                       $set->tax= Invoices::findOne($invoId)->tax;
                       $set->save();
                   }
                   
               }else{
                   if ($checkfileId==null and $checkInvoId==null){
                       $set=new Invonames();
                       $set->invoid=$invoId;
                       $set->no=$oldNo+1;
                       $set->fileId=$fileId;
                       $set->nm=$nm;
                       $set->date=date('Y-m-d');
                       $set->company=$c;
                       $set->tax= Invoices::findOne($invoId)->tax;
                       $set->save();
                       
                   }elseif ($checkfileId!=null and $checkInvoId==null){
                       $set=new Invonames();
                       $set->invoid=$invoId;
                       $set->no=$checkfileId->no;
                       $set->fileId=$fileId;
                       $set->nm=$nm;
                       $set->date=date('Y-m-d');
                       $set->company=$c;
                       $set->tax= Invoices::findOne($invoId)->tax;
                       $set->save();
                   }
               }
               
               break;
            }
        }
        
    }
}