<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "invoices".
 *
 * @property int $id
 * @property int $accId
 * @property string $date
 * @property int $userId
 * @property int $paid
 * @property int $company
 * @property int $type
 * @property int $tax
 * @property int $currency
 * @property int $line
 * @property int $description
 * @property int $exrateId
 * @property int $lok
 * @property int $clientId
 * @property string $numbername
 *
 * @property Invcontent[] $invcontents
 * @property Accounts $acc
 * @property Uzers $user
 * @property Invopayments[] $invopayments
 */
class Invoices extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    
    public $amount,$paida,$balance,$from,$to,$clienttype,$numbername;
    
    public static function tableName()
    {
        return 'invoices';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['accId', 'date', 'userId', 'currency','clientId'], 'required'],
            [['accId', 'userId', 'paid', 'company', 'type', 'tax','line','currency','exrateId','lok','clientId'], 'integer'],
            [['date'], 'safe'],
            [['description'], 'string', 'max' => 300],
            [['accId'], 'exist', 'skipOnError' => true, 'targetClass' => Accounts::className(), 'targetAttribute' => ['accId' => 'id']],
            [['userId'], 'exist', 'skipOnError' => true, 'targetClass' => Uzers::className(), 'targetAttribute' => ['userId' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'Invo #',
            'accId' => 'Accounted to',
            'date' => 'Invoice date',
            'userId' => 'User ID',
            'paid' => 'Paid',
            'company' => 'Company',
            'type' => 'Invoice type',
            'tax' => 'Tax',
            'currency' => 'Currency',
            'paida'=>'Paid',
            'clienttype'=>'Search by',
            'line'=>'Shipping line',
            'description'=>'Descriptions',
            'numbername'=>'Invo #',
            'clientId'=>'Client',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getInvcontents()
    {
        return $this->hasMany(Invcontent::className(), ['invId' => 'id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getAcc()
    {
        return $this->hasOne(Accounts::className(), ['id' => 'accId']);
    }
    
     
    public function getClient()
    {
        return $this->hasOne(Clients::className(), ['id' => 'clientId']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getUser()
    {
        return $this->hasOne(Uzers::className(), ['id' => 'userId']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getInvopayments()
    {
        return $this->hasMany(Invopayments::className(), ['invId' => 'id']);
    }
    
    
    public function getInvoiceContents($id)
    {
        return Invcontent::find()->where(['invId'=>$id])->all();
    }
    
    public function getInvoiceType($id){
        
        if ($id==1) return 'Invoice';
        elseif ($id==2) return 'Profoma';
        elseif ($id==3) return 'Debit';
    }
    
    public function getInvoiceTax($tx){
        
        if ($tx==1) return '+18%';
    }
    
    
    
    public function reverseInvoNo($no){
        
        $number = preg_replace('/[^0-9]/', '', $no);
        $letter = preg_replace('/[^a-zA-Z]/', '', $no);
        $all=array();
        
        $invono=Invonames::find()->where(['no'=>$number,'nm'=>$letter,'company'=>\Yii::$app->session->get('company')])->all();
        if ($invono != null) {
            foreach ($invono as $inv){
                $all[]=$inv->invoid;
            }
            return $all;
        }else {
            if(\Yii::$app->session->get('company')==1){ $number2=$number-72; }else{ $number2=$number; }
            
            //$number2=$number-72;
            $invono2=Invonames::find()->where(['no'=>$number2,'nm'=>$letter,'company'=>\Yii::$app->session->get('company')])->all();
            
            if ($invono2 != null) {
                foreach ($invono2 as $in){
                    $all[]=$in->invoid;
                }
                return $all;
            }
            else return null;
        }
        
    }
    
    
    public function getInvoiceNo($company,$invo){
       
   
      
        
        $fileId=Invoices::findOne($invo)->fileId;
        $accId=Invoices::findOne($invo)->accId;
        
        $alpha='A';
        $cnt=1;
        $return=null;
        $iN=$invo;
        $b=0;
       
        
        
      
        
        $accInvoices= Invoices::find()->where(['company'=>$company])->orderBy(['id'=>SORT_ASC])->all();
        
        if($fileId!=0) { 
            $invoices= Invoices::find()->where(['fileId'=>$fileId])->orderBy(['id'=>SORT_ASC])->all();
       
            if ($invoices != null){
                foreach ($invoices as $invoice){
                    if ($cnt !=1){
                        $alpha++;
                    }
                    
                    if ($invoice->id==$invo) break;
                    $cnt++;
                }  }  }
            
      
           Invonames::setInvoiceNo($invo,$fileId,$company,$alpha);
                
           $b=Invonames::find()->where(['invoid'=>$invo])->one();
          
           
           if(date('Y')<'2021'){
               if ($company != 1){
                $return=$b->no.$b->nm.'/'.date('Y',strtotime(Invoices::findOne($invo)->date));
               }elseif($company==1 and Invoices::findOne($invo)->date>'2019-09-04'){
                   $return=($b->no+72).$b->nm.'/'.date('Y',strtotime(Invoices::findOne($invo)->date));
               }elseif($company==1){
                   $return=$b->no.$b->nm.'/'.date('Y',strtotime(Invoices::findOne($invo)->date));
               }
           }else{
                   $return=$b->no.$b->nm.'/'.date('Y',strtotime(Invoices::findOne($invo)->date));
           
           }
           
        return $return;
        
    }
    
    
    
        public function getAccountId($cId){
        
        $nm= Clients::findOne($cId)->name; 
        $accounts= Accounts::find()->all();
        $id=null;
        if ($accounts != null){
            foreach ($accounts as $account){
                if (stripos($nm,$account->name)!== false){
                    $id=$account->id;
                }
            }
        }
        return $id;
    }
    
    
    
        public function getTotalAmountOfInvoices($from,$to,$pd,$cr){
        
        $total=0;
        
        $invoices= Invoices::find()
        ->where("date >= '$from' and date <= '$to' and paid='$pd' and currency='$cr' and company=:c",[':c'=>\Yii::$app->session->get('company')])
        ->orderBy(['date'=>SORT_DESC])->all();
        
        
        if ($invoices != null){
            foreach ($invoices as $invoice){
                $total=$total + Invcontent::getInvoiceCost($invoice->id);
            }
        }
        
        
        return $total;
        
    }
    
    
}