<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "invcontent".
 *
 * @property int $id
 * @property int $invId
 * @property int $serviceId
 * @property int $count
 * @property string $amount
 * @property string $date
 *
 * @property Invoices $inv
 * @property Servicecost $service
 */
class Invcontent extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    
    public $cnt;
    
    public static function tableName()
    {
        return 'invcontent';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['invId', 'serviceId','date'], 'required'],
            [['invId', 'serviceId', 'count'], 'integer'],
            [['amount'], 'number'],
            [['date'], 'safe'],
            [['invId'], 'exist', 'skipOnError' => true, 'targetClass' => Invoices::className(), 'targetAttribute' => ['invId' => 'id']],
            [['serviceId'], 'exist', 'skipOnError' => true, 'targetClass' => Services::className(), 'targetAttribute' => ['serviceId' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'invId' => 'Inv ID',
            'serviceId' => 'Service',
            'count' => 'Quantity',
            'amount' => 'Charges',
            'date' => 'On month',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getInv()
    {
        return $this->hasOne(Invoices::className(), ['id' => 'invId']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getService()
    {
        return $this->hasOne(Services::className(), ['id' => 'serviceId']);
    }
    
    public function getInvoiceCost($id){
        $ret=0;
        
        $contents=Invcontent::find()->where(['invId'=>$id])->all();
        
        if ($contents!=null) {
            foreach ($contents as $content){
                $ret=$ret+($content->amount*$content->count);
            }
        }
        
        if (Invoices::findOne($id)->tax==1){
            $ret=$ret + $ret*0.18;
        }
        
           if ((($ret-Invopayments::getInvoicePaidAmount($id))==0) and ($ret!=0)){
            $inv= Invoices::findOne($id);
            $inv->paid=1;
            $inv->save();
        }
        
        return $ret;
    }
    
        public function getInvoiceVatCost($id){
        $ret=0;
        $vat=0;
        
        $contents=Invcontent::find()->where(['invId'=>$id])->all();
        
        if ($contents!=null) {
            foreach ($contents as $content){
                $ret=$ret+($content->amount*$content->count);
            }
        }
       
        if (Invoices::findOne($id)->tax==1){
            $vat=$ret*0.18;
        }
        
        return $vat;
    }
    
    public function checkServiceInInvoice($servid,$invoId,$amount){
        
        $ret=null;
        
        $fileId= Invoices::findOne($invoId)->fileId;
        
        if ($fileId ==0){
        
        $contents=Invcontent::find()->where(['invId'=>$invoId,'serviceId'=>$servid])->all();
        
        if ($contents != null){
            foreach ($contents as $content){
                if($content->amount==$amount) { $ret=$content->id; }
            }
        }
        
        }else{
           
            $invoices= Invoices::find()->where(['fileId'=>$fileId])->all();
            
            if ($invoices != null){
                foreach ($invoices as $inv){
                    
                    
                    $contents=Invcontent::find()->where(['invId'=>$inv->id,'serviceId'=>$servid])->all();
                    
                    if ($contents != null){
                        foreach ($contents as $content){
                            if($content->amount==$amount) { $ret=$content->id; }
                        }
                    }
                    
                }
            }

            
        }
        return $ret;
    }
}