<?php

namespace app\models;

use Yii;
use phpDocumentor\Reflection\Types\Null_;
use app\controllers\MovefuelratioController;

/**
 * This is the model class for table "fuelrequest".
 *
 * @property int $id
 * @property int $truckId
 * @property int $driverId
 * @property string $fueldate
 * @property string $recorddate
 * @property string $volume
 * @property string $lastdistance
 * @property string $priceperlitre
 * @property int $status
 *
 * @property Cardrivers $driver
 * @property Trailers $truck
 */
class Fuelrequest extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public $from, $to; 
    public static function tableName()
    {
        return 'fuelrequest';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['truckId', 'driverId', 'fueldate', 'recorddate', 'volume', 'lastdistance', 'priceperlitre','byy'], 'required'],
            [['status'], 'integer'],
            [['fueldate', 'recorddate'], 'safe'],
            [['volume', 'lastdistance', 'priceperlitre'], 'number'],
            [['driverId'], 'exist', 'skipOnError' => true, 'targetClass' => Cardrivers::className(), 'targetAttribute' => ['driverId' => 'id']],
            [['truckId'], 'exist', 'skipOnError' => true, 'targetClass' => Cars::className(), 'targetAttribute' => ['truckId' => 'plateno']],
            ['fueldate', 'compare', 'compareValue' => date('Y-m-d'), 'operator' => '<=','message'=>"Date can not be above today" ],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'truckId' => 'Truck',
            'driverId' => 'Driver',
            'fueldate' => 'Fueled date',
            'recorddate' => 'Recorded date',
            'volume' => 'Volume(Lts)',
            'lastdistance' => 'Last distance(Km)',
            'priceperlitre' => 'Price perlitre(Tsh)',
            'status' => 'Status',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getDriver()
    {
        return $this->hasOne(Cardrivers::className(), ['id' => 'driverId']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getTruck()
    {
        return $this->hasOne(Cars::className(), ['plateno' => 'truckId']);
    }
    
    public function checkDublicate($tId,$dt,$vl){
        
        $val=true;
        
        $fuels= Fuelrequest::find()
                ->where(['truckId'=>$tId,'fueldate'=>$dt])
                ->all();
        
                if ($fuels != null){
                    $val=false;
                }
                
                return $val;
    }
    
    public function getConsumedFuelByEmpty($fId){
        $consumed=0;
        
        $movements= Movements::find()
        ->where(['fuelId'=>$fId])->all();
        
        if ($movements != null) {
            foreach ($movements as $movement) {
                if ($movement->movetype->triptype==2){
                    $consumed=$consumed+ Movefuelratio::getConsumedFuel($movement->movetype->id,$movement->truck->typeId);
                }
            }
        }
        
        return $consumed;
    }
    
    public function getConsumedFuelByFull($fId){
        $consumed=0;
        
        $movements= Movements::find()
        ->where(['fuelId'=>$fId])->all();
        
        if ($movements != null) {
            foreach ($movements as $movement) {
                if ($movement->movetype->triptype==1){
                    $consumed=$consumed+ Movefuelratio::getConsumedFuel($movement->movetype->id,$movement->truck->typeId);
                }
            }
        }
        
        return $consumed;
        
    }
    
    
    public function getConsumedFuelByOther($fId){
        $consumed=0;
        
        $movements= Movements::find()
        ->where(['fuelId'=>$fId])->all();
        
        if ($movements != null) {
            foreach ($movements as $movement) {
                if ($movement->movetype->triptype==3){
                    $consumed=$consumed+ Movefuelratio::getConsumedFuel($movement->movetype->id,$movement->truck->typeId);
                }
            }
        }
        
        
        return $consumed;
    }
    
    public function getTruckActiveFuel($tId,$ec){
        $gouse=null;
        $virtue=0;
        $used=array();
        $cnt=0;
        
        $aFuels=Fuelrequest::find()
        ->where(['truckId'=>$tId, 'status'=>1])->all();
        
        if ($aFuels != null){
            foreach ($aFuels as $fuel){
                $consumed= Fuelrequest::getConsumedFuelByEmpty($fuel->id) + Fuelrequest::getConsumedFuelByFull($fuel->id) + Fuelrequest::getConsumedFuelByOther($fuel->id) + Offuels::getConsumedfuels($fuel->id);
                $remaining=$fuel->volume-$consumed;
                
                if ($remaining >= $ec) {
                    $gouse=$fuel->id;
                    break;
                }elseif ($remaining >= round($ec)){
                    $gouse=$fuel->id;
                    break;
                }elseif ($remaining>=10 and ($remaining+1)>=round($ec)){
                    $gouse=$fuel->id;
                    break;
                }elseif ($remaining>=10 and count($aFuels)>1){
                  $virtue=$virtue+$remaining;
                  if ($virtue>=$ec){
                      $gouse=$fuel->id;
                      
                      if (count($used)!=0){
                      for ($i=0; $i<count($used); $i++){
                          $usedfuel= Fuelrequest::findOne($used[$i]);
                          $usedfuel->status=0;
                          $usedfuel->save();
                      } }
                      
                  }else {
                     $used[$cnt]=$fuel->id; 
                     $cnt++;
                  }
                }
            }
        }
        
        return $gouse;
    }
    
    public function countTruckActiveFuel($tId){
         $cnt=0;
        
        $aFuels=Fuelrequest::find()
        ->where(['truckId'=>$tId, 'status'=>1])->all();
        
        if ($aFuels != null){
            foreach ($aFuels as $fuel){
                $consumed= Fuelrequest::getConsumedFuelByEmpty($fuel->id) + Fuelrequest::getConsumedFuelByFull($fuel->id) + Fuelrequest::getConsumedFuelByOther($fuel->id) + Offuels::getConsumedfuels($fuel->id);
                $remaining=$fuel->volume-$consumed;
                
                if ($remaining < 5){
                    $af=Fuelrequest::findOne($fuel->id);
                    $af->status=0;
                    if(!$af->save()){ \Yii::$app->session->setFlash('error','Save error, some field missing'); }
                }else {
                    $cnt++;
                }
            }
        }
        
        return $cnt;
    }
    
    
    public function getTruckFuelOnHand($tId){
        $cnt=0;
        
        $aFuels=Fuelrequest::find()
        ->where(['truckId'=>$tId, 'status'=>1])->all();
        
        if ($aFuels != null){
            foreach ($aFuels as $fuel){
                $consumed= Fuelrequest::getConsumedFuelByEmpty($fuel->id) + Fuelrequest::getConsumedFuelByFull($fuel->id) + Fuelrequest::getConsumedFuelByOther($fuel->id) + Offuels::getConsumedfuels($fuel->id);
                $remaining=$fuel->volume-$consumed;
                
                if ($remaining < 5){
                    $af= Fuelrequest::findOne($fuel->id);
                    $af->status=0;
                    $af->save();
                }else {
                    $cnt=$cnt+$remaining;
                }
            }
        }
        
        return $cnt;
    }
    
    
    
    
    public function getTruckConsumedfuelByTime($tId,$from,$to){
        
        $consumed=0;
        $outside=0;
        $cost=0;
        $ary=null;
        
        $movetypes=Movetype::find()->all();
        
        if ($movetypes != null){
            foreach ($movetypes as $movetype){
                
                $movements= Movements::find()
                ->where("interchangedate >= '$from' and interchangedate <= '$to' and truckId='$tId' and movetypeId='$movetype->id' and company=:c",[':c'=>\Yii::$app->session->get('company')])
                ->orderBy(['interchangedate'=>SORT_DESC])->all();
                
                $prevdate=null;
                $store=null;
                $trp=0;
                
                if ($movements !=null){
                    foreach ($movements as $movement){
                        if (($prevdate==null) and ($movement->movetype->triptype==2) and ($movement->size==2)){
                            $c=0;
                            $dayMoves= Movements::find()
                            ->where(['truckId'=>$tId,'movetypeId'=>$movetype->id,'size'=>2,'interchangedate'=>$movement->interchangedate])
                            ->all();
                            
                            if ($dayMoves!=null){
                                foreach ($dayMoves as $move){
                                    if (($move->interchangedate>= $from) and ($move->interchangedate<=$to))  $c=$c+1;
                                }
                            }
                            
                            
                            $consumed=$consumed + round($c/2) * Movefuelratio::getConsumedFuel($movetype->id,Cars::findOne($tId)->typeId);
                            $cost=$cost + round($c/2) * Movefuelratio::getConsumedFuel($movetype->id,Cars::findOne($tId)->typeId) * $movement->fuel->priceperlitre;
                            $prevdate=$movement->interchangedate;
                            
                        }elseif (($prevdate!=$movement->interchangedate) and ($movement->movetype->triptype==2) and ($movement->size==2)){
                            $c=0;
                            $dayMoves= Movements::find()
                            ->where(['truckId'=>$tId,'movetypeId'=>$movetype->id,'size'=>2,'interchangedate'=>$movement->interchangedate])
                            ->all();
                            
                            if ($dayMoves!=null){
                                foreach ($dayMoves as $move){
                                    if (($move->interchangedate>= $from) and ($move->interchangedate<=$to))  $c=$c+1;
                                }
                            }
                            
                            
                            $consumed=$consumed + round($c/2) * Movefuelratio::getConsumedFuel($movetype->id,Cars::findOne($tId)->typeId);
                            $cost=$cost + round($c/2) * Movefuelratio::getConsumedFuel($movetype->id,Cars::findOne($tId)->typeId) * $movement->fuel->priceperlitre;
                            $prevdate=$movement->interchangedate;
                            
                        }elseif ($movement->movetype->triptype!=2){
                            $consumed=$consumed + Movefuelratio::getConsumedFuel($movetype->id,Cars::findOne($tId)->typeId);
                            $cost=$cost + Movefuelratio::getConsumedFuel($movetype->id,Cars::findOne($tId)->typeId) * $movement->fuel->priceperlitre;
                        }elseif ($movement->movetype->triptype==2 and $movement->size!=2){
                            $consumed=$consumed + round($c/2) * Movefuelratio::getConsumedFuel($movetype->id,Cars::findOne($tId)->typeId);
                            $cost=$cost + Movefuelratio::getConsumedFuel($movetype->id,Cars::findOne($tId)->typeId) * $movement->fuel->priceperlitre;
                        }
                    }
                }
            }
        }
        
         $offfuels= Offuels::find()
        ->where("date >= '$from' and date <= '$to' and truckId='$tId'")
        ->all();
        
        if ($offfuels != null){
            foreach ($offfuels as $off){
                $consumed=$consumed+$off->amount;
                $cost=$cost + $off->amount* $off->fuel->priceperlitre;
            }
        }
        
        $ary['consumed']=$consumed;
        $ary['cost']=$cost;
        
        return $ary;
    }
    
    
    public function getTruckConsumedfuelByTimeCost($tId,$from,$to){
        
        $cost=0;
        $costout=0;
        
        $movements= Movements::find()
        ->where("interchangedate >= '$from' and interchangedate <= '$to' and truckId='$tId'")
        ->all();
        
        if ($movements != null){
            foreach ($movements as $movement){
                $cost=$cost+(Movefuelratio::getConsumedFuel($movement->movetype->id,$movement->truck->typeId));
            }
        }
        //*$movement->fuel->priceperlitre
        
        $offfuels= Offuels::find()
        ->where("date >= '$from' and date <= '$to' and truckId='$tId'")
        ->all();
        
        if ($offfuels != null){
            foreach ($offfuels as $off){
                $costout=$costout+$off->amount;
                
                //Fuelrequest::findOne($off->fuelId)->priceperlitre*
            }
        }
        
        return ($cost +$costout);
        
    }
    
    
    public function getTruckLastFueledDate($tId){
        $dt='Never fueled';
        
        $fuels=Fuelrequest::find()
        ->where(['truckId'=>$tId])->orderBy(['fueldate'=>SORT_DESC])->all();
        
        if ($fuels != null){
            foreach ($fuels as $fuel){
                $dt=date('d-m-Y',strtotime($fuel->fueldate));
                break;
            }
        }
        
        return $dt;
        
    }
    
    
        public function getTruckLastFueledDateWithCondition($tId,$f,$t){
        $dt='Nill';
        
        $fuels=Fuelrequest::find()
        ->where("fueldate >= '$f' and fueldate <= '$t' and truckId=:id",[':id'=>$tId])->orderBy(['fueldate'=>SORT_DESC])->all();
        
        if ($fuels != null){
            foreach ($fuels as $fuel){
                $dt=date('d-m-Y',strtotime($fuel->fueldate));
                break;
            }
        }
        
        return $dt;
        
    }
    
    public function getTruckFueledAmountByTime($tId,$from,$to){
        
        $total=0;
        
        $fuels=Fuelrequest::find()
        ->where("fueldate >= '$from' and fueldate <= '$to' and truckId=:id",[':id'=>$tId])->all();
        
        if ($fuels != null){
            foreach ($fuels as $fuel){
                $total=$total+ $fuel->volume;
            }
        }
        
        return $total;
    }
    
    
    public function getTruckFueledAmountByTimeCost($tId,$from,$to){
        
        $total=0;
        
        $fuels=Fuelrequest::find()
        ->where("fueldate >= '$from' and fueldate <= '$to' and truckId=:id",[':id'=>$tId])->all();
        
        if ($fuels != null){
            foreach ($fuels as $fuel){
                $total=$total+ $fuel->volume*$fuel->priceperlitre;
            }
        }
        
        return $total;
    }
    
    
    public function getTruckBorrowedFuelVolume($tId,$fId){
     
        $totalconsumed=0;
        
        $fuels=Movements::find()
        ->where("fuelId=:kd and truckId=:id",[':id'=>$tId,':kd'=>$fId])->all();
        
        
        if ($fuels != null){
            foreach ($fuels as $fuel){
                $totalconsumed=$totalconsumed+Movefuelratio::getConsumedFuel($fuel->movetype->id,$fuel->truck->typeId);
            }
        }
        
        return $totalconsumed;
    }
    
    
    public function returnBorrowedFuel($tId,$fueId,$qnt){
      
        $totalconsumed=0;
        
        $fuels=Movements::find()
        ->where("fuelId=:kd and truckId=:id",[':id'=>$tId,':kd'=>285])->all();
      
        
        if ($fuels != null){
            foreach ($fuels as $fuel){
               $totalconsumed=$totalconsumed+Movefuelratio::getConsumedFuel($fuel->movetype->id,$fuel->truck->typeId);
               if ($totalconsumed<=$qnt){
               $fuel->fuelId=$fueId;
               $fuel->save();
               }else {
                   break;
               }
            }
        }
    }
}
