<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "fromclients".
 *
 * @property int $id
 * @property int $status
 * @property string $contno
 * @property string $truckno
 * @property string $date
 * @property file $upexl
 */
class Fromclients extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    
    public $upexl;
    
    public static function tableName()
    {
        return 'fromclients';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['contno', 'truckno'], 'required'],
            [['contno'], 'string', 'max' => 16],
            [['truckno'], 'string', 'max' => 7],
            [['upexl'], 'file', 'extensions' => 'xlsx'],
            [['status'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'contno' => 'Contno',
            'truckno' => 'Truckno',
            'upexl'=>'Excell file',
            'status'=>'Status',
        ];
    }
    
    
        public function checkcontainer($clientId){
        
        $from=date('Y-m-d',strtotime('-1 month'));
        $to=date('Y-m-d');
       
        $cn=Fromclients::findOne($clientId)->contno;
        $tk=Fromclients::findOne($clientId)->truckno;
        
        $containers=Movements::find()
        ->where("interchangedate >= '$from' and interchangedate <= '$to' and containerno='$cn'")->orderBy(['interchangedate'=>SORT_DESC])->all();
        
        
        if($containers != null){
            $fromC= Fromclients::findOne($clientId);
            $fromC->status=0;
            if($fromC->save()){
            $rtn=$cn;
            }
        }
        
        return $cn;
    }
    
    
    public function checkcontainerbycontainerno($contno){
        
        $from=date('Y-m-d',strtotime('-1 month'));
        $to=date('Y-m-d');
        
        $containers=Movements::find()
        ->where("interchangedate >= '$from' and interchangedate <= '$to' and containerno='$contno'")->orderBy(['interchangedate'=>SORT_DESC])->all();
        
        
        if($containers != null){
            $fromC= Fromclients::findOne(['contno'=>$contno,'status'=>1]);
            $fromC->status=0;
            $fromC->save();
        }
    }
    

}
