<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "exrate".
 *
 * @property int $id
 * @property string $rate
 * @property string $date
 */
class Exrate extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'exrate';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['rate', 'date'], 'required'],
            [['rate'], 'number'],
            [['date'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'rate' => '1usd = ',
            'date' => 'Date',
        ];
    }
    
    public function getRecentRate(){
        $rt=0;
        
        $rates= Exrate::find()->orderBy(['id'=>SORT_DESC])->all();
        
        if ($rates != null){
            foreach ($rates as $rate){
                $rt=$rate->rate;
                break;
            }
        }
        
        return $rt;
    }
    
    public function getRecentRateId(){
        $rt=null;
        
        $rates= Exrate::find()->orderBy(['id'=>SORT_DESC])->all();
        
        if ($rates != null){
            foreach ($rates as $rate){
                $rt=$rate->id;
                break;
            }
        }
        
        return $rt;
    }
    
    public function getInvoiceRate($id){
        $rt=0;
        
        $rates= Exrate::findOne($id);
        if ($rates != null){
                $rt=$rates->rate;
            }
        
        return $rt;
    }
}
