<?php

namespace app\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use app\models\Docsupload;

/**
 * DocsuploadSearch represents the model behind the search form of `app\models\Docsupload`.
 */
class DocsuploadSearch extends Docsupload
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'docsId', 'fileId', 'byy'], 'integer'],
            [['name', 'onn'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Docsupload::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'docsId' => $this->docsId,
            'fileId' => $this->fileId,
            'onn' => $this->onn,
            'byy' => $this->byy,
        ]);

        $query->andFilterWhere(['like', 'name', $this->name]);

        return $dataProvider;
    }
}
