<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "dispatchcontents".
 *
 * @property int $id
 * @property int $dispatchId
 * @property int $storeId
 * @property int $quantity
 *
 * @property Wstoredispatch $dispatch
 * @property Wstore $store
 */
class Dispatchcontents extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'dispatchcontents';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['dispatchId', 'storeId', 'quantity'], 'required'],
            [['dispatchId', 'storeId', 'quantity'], 'integer'],
            [['dispatchId'], 'exist', 'skipOnError' => true, 'targetClass' => Wstoredispatch::className(), 'targetAttribute' => ['dispatchId' => 'id']],
            [['storeId'], 'exist', 'skipOnError' => true, 'targetClass' => Wstore::className(), 'targetAttribute' => ['storeId' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'dispatchId' => 'Dispatch ID',
            'storeId' => 'Spare/tool',
            'quantity' => 'Quantity',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getDispatch()
    {
        return $this->hasOne(Wstoredispatch::className(), ['id' => 'dispatchId']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getStore()
    {
        return $this->hasOne(Wstore::className(), ['id' => 'storeId']);
    }
    
    public function getStoreBalance($id){
        $cnt=0;
        $balance=0;
        $qnt= Wstore::findOne($id)->quantity;
        
        $expenses=Dispatchcontents::find()->where(['storeId'=>$id])->all();
        
        if ($expenses != null){
            foreach ($expenses as $expense){
                $cnt=$cnt+$expense->quantity;
            }
        }
        
        $balance=$qnt-$cnt;
        
        if ($balance<=0){
            $store= Wstore::findOne($id);
            $store->status=0;
            
            if (Bills::findOne($store->billId) != null){
            $store->save();
            }else{
                $store->billId=27;
                $store->save();
            }
        }
        
        return $balance;
    }
    
 
}
