<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "defectivetrucks".
 *
 * @property int $id
 * @property string $carId
 * @property int $status
 * @property string $reason
 * @property string $indate
 * @property string $outdate
 * @property string $expected
 *
 * @property Cars $car
 */
class Defectivetrucks extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public $from, $to; 
    
    public static function tableName()
    {
        return 'defectivetrucks';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['carId', 'reason', 'indate', 'outdate','company'], 'required'],
            [['status'], 'integer'],
            [['indate', 'outdate','expected'], 'safe'],
            ['indate', 'compare', 'compareValue' => date('Y-m-d'), 'operator' => '<=','message'=>'Date can not be above today' ],
           // ['indate', 'compare', 'compareValue' => date('Y-m-d',strtotime("-60 days")), 'operator' => '>=','message'=>'Date is too old' ],
            [['carId'], 'string', 'max' => 7],
            [['reason'], 'string', 'max' => 300],
            [['carId'], 'exist', 'skipOnError' => true, 'targetClass' => Cars::className(), 'targetAttribute' => ['carId' => 'plateno']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'carId' => 'Car',
            'status' => 'Status',
            'reason' => 'Reason',
            'indate' => 'In date',
            'outdate' => 'Out date',
            'expected'=>'Exp date',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getCar()
    {
        return $this->hasOne(Cars::className(), ['plateno' => 'carId']);
    }
    
    public function checkCarDublicate($carId){
        
        $cars= Defectivetrucks::find()->
        where(['carId'=>$carId,'outdate'=>'0000-00-00'])->all();
        
        return $cars;
        
    }
    
    public function checkCarAvailability($carId,$from,$to){
        
        $cars= Defectivetrucks::find()->
        where("indate >= '$from' and indate <= '$to' and carId='$carId'")->all();
        
        return $cars;
        
    }
    
    public function getStatusValue($id){
         if ($id==0) return 'Pending';
        elseif ($id==1) return 'On Maintanance';
        elseif ($id==3) return 'Complicated';
        elseif ($id==2) return 'Completed';
    }
    
    public function changeTruckDispatchStatus($id){
        
        $defected= Defectivetrucks::find()->where(['carId'=>$id,'status'=>0])->all();
        
        if ($defected != null){
            foreach ($defected as $defe){
                $defe->status=1;
                $defe->save();
            }
        }
        
    }
    
    public function getTruckcontent($truckId,$indate){
        
        $to=date('Y-m-d');
        $dispatches= Wstoredispatch::find()->where("date >= '$indate' and date <= '$to' and truckId=:id",[':id'=>$truckId])->all();
        $spares=array();
        $cnt=0;
        
        if ($dispatches != null){
            foreach ($dispatches as $dispatch){
                $contents= Dispatchcontents::find()->where(['dispatchId'=>$dispatch->id])->all();
                if ($contents != null){
                    foreach ($contents as $content){
                        $spares[$cnt]['spare']= $content->store->service->name;
                        $spares[$cnt]['quantity']=$content->quantity;
                    }
                }
               
            }
        }
        
        return $spares;
    }
    
    public function getDefectiveQuantity(){
        
        $cars= Cars::find()->where(['company'=>\Yii::$app->session->get('company'),'status'=>1])->all();
        $total=0;
        
        if ($cars != null){
            foreach ($cars as $car){
                $defected= Defectivetrucks::find()->where(['carId'=>$car->plateno,'outdate'=>'0000-00-00'])->all();
                if ($defected != null) $total=$total+1;
            }
        }
        return $total;
    }
}