<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "clients".
 *
 * @property int $id
 * @property string $name
 * @property string $address
 * @property string $phone
 * @property string $email
 * @property string $vrn
 * @property string $tin
 */
class Clients extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'clients';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['name','type','tin','vrn'], 'required'],
            ['name', 'unique', 'targetClass' => 'app\models\Clients', 'message' => 'This client is present'],
            [['name', 'address', 'email'], 'string', 'max' => 45],
            [['phone'], 'string', 'max' => 13],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'name' => 'Name',
            'address' => 'Address',
            'phone' => 'Phone',
            'email' => 'Email',
            'type'=>'Client category',
            'tin'=>'TIN #',
            'vrn'=>'VRN #',
        ];
    
    }
    
    
        public function getClienttype($id){
        if ($id==1){
            return 'Client';
        }elseif ($id==2){
           return 'Shipping line'; 
        }
    }
    
    
        
    public function getClientId($name){
        
        $types= Clients::find()
        ->where(['LIKE',strtolower('name'),strtolower($name)])
        ->all();
        
        $ids=null;
        
        if ($types != null){
            foreach ($types as $type){
                $ids[]=$type->id;
            }
        }
        
        return $ids;
    }
    
    
    

}