<?php

namespace app\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use app\models\Cfile;

/**
 * CfileSearch represents the model behind the search form of `app\models\Cfile`.
 */
class CfileSearch extends Cfile
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'shipmenttype', 'incoterm', 'fstatus', 'acstatus', 'delivery', 'dangestatus', 'byy', 'clientId'], 'integer'],
            [['blnumber', 'shipper', 'saleman', 'description', 'onn'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Cfile::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'shipmenttype' => $this->shipmenttype,
            'incoterm' => $this->incoterm,
            'fstatus' => $this->blnumber==null?1:$this->fstatus,
            'acstatus' => $this->acstatus,
            'delivery' => $this->delivery,
            'dangestatus' => $this->dangestatus,
            'byy' => $this->byy,
            'onn' => $this->onn,
            'clientId' => $this->clientId,
            'company'=>\Yii::$app->session->get('company'),
        ]);

        $query->andFilterWhere(['like', 'blnumber', $this->blnumber])
            ->andFilterWhere(['like', 'shipper', $this->shipper])
            ->andFilterWhere(['like', 'saleman', $this->saleman])
            ->andFilterWhere(['like', 'description', $this->description]);

        return $dataProvider;
    }
}
