<?php

namespace app\models;

use Yii;
use PHPUnit\Framework\Constraint\Count;
use yii\db\conditions\LikeCondition;

/**
 * This is the model class for table "cartype".
 *
 * @property int $id
 * @property string $name
 * @property string $model
 *
 * @property Cars[] $cars
 */
class Cartype extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public $numbers,$fulltypename;
    
    public static function tableName()
    {
        return 'cartype';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['model', 'carmodelId'], 'required'],
            [['name'], 'string', 'max' => 35],
            [['model'], 'string', 'max' => 50],
            ['model', 'unique', 'targetClass' => 'app\models\Cartype', 'message' => 'This model exist'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'model' => 'Model',
            'numbers'=>'Number of cars',
            'carmodelId'=>'Brand',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getCars()
    {
        return $this->hasMany(Cars::className(), ['typeId' => 'id']);
    }
    
    
    public function getCarmodel()
    {
        return $this->hasOne(Carmodel::className(), ['id' => 'carmodelId']);
    }
    
    public function getNumberOfCars($id){
        
        $cars= Cars::find()
        ->where(['typeId'=>$id,'status'=>1,'company'=>\Yii::$app->session->get('company')])->all();
        
       return Count($cars);
    }
    
    public function getFulltypename(){
        
        $tn=$this->carmodel->name.' '.$this->model;
        
        return $tn;
        
    }
    
    public function getTrailersId(){
       
        $trailId=null;
        
        
        $mods= Carmodel::find()->where([strtolower('name')=>'trailer'])->all();
        
        if ($mods != null){
            foreach ($mods as $mod){
               
                $trailers= Cartype::find()->where(['carmodelId'=>$mod->id])->all();
               
                if ($trailers != null){
                    foreach ($trailers as $trailer){
                        $trailId[]=$trailer->id;
                    }
                }
                
            }
        }
        

        
        return $trailId;
    }
    
    public function getHorsesId(){
      
        $trailId=null;
        
        $mods= Carmodel::find()->where(['NOT LIKE',strtolower('name'),['trailer']])->all();
       
        if ($mods != null){
            foreach ($mods as $mod){
                
                $horses= Cartype::find()->where(['carmodelId'=>$mod->id])->all();
                
                if ($horses != null){
                    foreach ($horses as $horse){
                        $trailId[]=$horse->id;
                    }
                }
                
            }
        }
        
        return $trailId;
    }
    
    
        public function getOnlyHorsesId(){
      
        $trailId=null;
        
        $mods= Carmodel::find()->where(['NOT LIKE',strtolower('name'),['trailer','Land cruiser']])->all();
       
        if ($mods != null){
            foreach ($mods as $mod){
                
                $horses= Cartype::find()->where(['carmodelId'=>$mod->id])->all();
                
                if ($horses != null){
                    foreach ($horses as $horse){
                        $trailId[]=$horse->id;
                    }
                }
                
            }
        }
        
        return $trailId;
    }
    
    
    
    public function getTypeId($name){
        
        $mds= Carmodel::find()->where(['LIKE',strtolower('name'),$name])->all();
        $ids=null;
        
        
        if ($mds != null){
            foreach ($mds as $md){
                
                $types= Cartype::find()->where(['carmodelId'=>$md->id])->all();
                
                if ($types != null){
                    foreach ($types as $type){
                        $ids[]=$type->id;
                    }
                }
                
            }
        }
        
        return $ids;
    }
    
    
    
    public function getCartypeId($name){
        
        $types= Cartype::find()->all();
        
        $ret=9;
        
        if ($types != null){
            foreach ($types as $type){
                $pos1=stripos($name,$type->name);
                $pos2=stripos($name,$type->model);
                if ($pos1!==false){
                    $ret=$type->id;  
                    break;
                }elseif($pos2!==false){
                 $ret=$type->id;   
                 break;
                }
            }
        }
        
        return $ret;
        
    }
  
    
    public function getCarTypeByPlate($pl){
        
        if ($pl==null){ 
            return 'No car';
        }
        else {
            return Cars::findOne($pl)->type->name;
        }
    }
    
    
}
