<?php

namespace app\models;

use Yii;
use yii\helpers\ArrayHelper;

/**
 * This is the model class for table "cars".
 *
 * @property int $typeId
 * @property int $capacity
 * @property string $plateno
 * @property int $status
 * @property string $datepurchased
 * @property string $chasisno
 *
 * @property Cardrivers[] $cardrivers
 * @property Cartype $type
 * @property Trailers[] $trailers
 * @property Trailers[] $trailers0
 */
class Cars extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    
    public $driver, $trailer; 
    
    public static function tableName()
    {
        return 'cars';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['typeId', 'plateno', 'datepurchased','chasisno'], 'required'],
            [['typeId', 'status','company','capacity'], 'integer'],
            [['datepurchased'], 'safe'],
            [['plateno'], 'string', 'max' => 7],
            [['chasisno'], 'string','max' =>25],
            [['plateno'], 'unique'],
            [['typeId'], 'exist', 'skipOnError' => true, 'targetClass' => Cartype::className(), 'targetAttribute' => ['typeId' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'typeId' => 'Car model',
            'plateno' => 'Plateno',
            'status' => 'Status',
            'datepurchased' => 'Purchased date',
            'trailer'=>'Car trailer',
            'driver'=>'Car driver',
            'capacity'=>'Car capacity',
            'chasisno'=>'Chasis no',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getCardrivers()
    {
        return $this->hasMany(Cardrivers::className(), ['carId' => 'plateno']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getType()
    {
        return $this->hasOne(Cartype::className(), ['id' => 'typeId']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getTrailers()
    {
        return $this->hasMany(Trailers::className(), ['horseid' => 'plateno']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getTrailers0()
    {
        return $this->hasMany(Trailers::className(), ['trailerid' => 'plateno']);
    }
    
    
    public function getCompanyCars()
    {
        
        $cars= Cars::find()->where(['company'=>\Yii::$app->session->get('company')])->all();
        
        $compcars=null;
        
        if ($cars != null){
            foreach ($cars as $car){
                
                $compcars[]=$car->plateno;
                
            }
        }
        
        return $compcars;
        
    }
 
    
    public function getTypequantity($id){
        
        $types= Cartype::find()->where(['carmodelId'=>$id])->all();
        $cars=0;
        if ($types != null){
            foreach ($types as $type){
                $cars= $cars + count(Cars::find()->where(['typeId'=>$type->id,'status'=>1,'company'=>\Yii::$app->session->get('company')])->all());
           }
        }
        
        
        return $cars;
    }
    
    
        public function getCarCostByTime($carId,$from,$to){
        
        $f=date('Y-m-d',strtotime($from));
        $t=date('Y-m-d',strtotime($to));
        $sumT=0;
        $bills= Bills::find()->where("date >= '$f' and date <= '$t' and company=:c", [':c'=>\Yii::$app->session->get('company')])->all();
        
        if ($bills != null){
            foreach ($bills as $bill){
                if (Wshopbills::findOne(['billid'=>$bill->id]) != null){
                    $billIds[]=$bill->id;
                }
            }
        }
        
        
        $billcontents=Billcontent::find()->where(['carId'=>$carId,'billId'=>$billIds])->all();
        
        if ($billcontents != null){
            
            foreach ($billcontents as $billcontent){
                if (Bills::findOne($billcontent->billId)->currency==1){
                    $sumT=$sumT + $billcontent->amount*$billcontent->count;
                }
                
                
            }
        }
        
        return $sumT;
    }
    
    
     public function getcarcapacity($id){
        if ($id==1) return 'Full car';
        elseif ($id==2) return 'Empty car';
    }
    
    
    
}