<?php

namespace app\models;

use Yii;
use app\models\Cars;

/**
 * This is the model class for table "cardrivers".
 *
 * @property int $id
 * @property int $userId
 * @property string $carId
 * @property int $status
 * @property string $dateassigned
 *
 * @property Cars $car
 * @property Uzers $user
 */
class Cardrivers extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'cardrivers';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['userId', 'carId', 'dateassigned'], 'required'],
            [['userId', 'status'], 'integer'],
            [['dateassigned'], 'safe'],
            [['carId'], 'string', 'max' => 7],
            [['carId'], 'exist', 'skipOnError' => true, 'targetClass' => Cars::className(), 'targetAttribute' => ['carId' => 'plateno']],
            [['userId'], 'exist', 'skipOnError' => true, 'targetClass' => Uzers::className(), 'targetAttribute' => ['userId' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'userId' => 'Car driver',
            'carId' => 'Car',
            'status' => 'Status',
            'dateassigned' => 'Dateassigned',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getCar()
    {
        return $this->hasOne(Cars::className(), ['plateno' => 'carId']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getUser()
    {
        return $this->hasOne(Uzers::className(), ['id' => 'userId']);
    }
    
    public function getActiveDriver($id){
        
        $adriver=Null;
        $driver= Cardrivers::find()
        ->where(['carId'=>$id,'status'=>1])->orderBy(['dateassigned'=>SORT_DESC])
        ->all();
        
        if ($driver != null) $adriver=$driver;   //$driver->user->firstname.' '.$driver->user->lastname;
        
        return $adriver;
        
    }
    
    
    public function getDriverCars($id){
        
        $drivercar=Null;
      
       $cars= Cardrivers::find()->where(['userId'=>$id, 'status'=>1])->all();
        
       $campcars=Cars::find()->where(['company'=>\Yii::$app->session->get('company'),'status'=>1])->all();
       
        if ($cars != null){
            if (count($campcars)==count($cars)){
                $drivercar='All';
            }else{
                foreach ($cars as $car){
                    $drivercar= $car->carId.' ('.Cars::getcarcapacity(Cars::findOne($car->carId)->capacity).') |';
                } 
            } }
        
        return $drivercar;
        
    }
    
    
    public function getdrivercarcapacityinoperation($id,$cardrove,$dt){
        
        $cap=0;
      
       $cars= Cardrivers::find()->where(['userId'=>$id, 'status'=>1])->all();
       
        if ($cars != null){
           $dtcomp="2023-05-01";
           
                foreach ($cars as $car){
                    
                    if($dt>=$dtcomp){
                        if(Cars::findOne($cardrove)->capacity==1 and $dt>=$dtcomp){
                            $cap=1;
                            break;
                        }elseif($car->car->capacity==Cars::findOne($cardrove)->capacity and $dt>=$dtcomp){
                            $cap=1;
                            break;
                        }else{
                            $cap=0;
                        }
                      } else{
                            $cap=1;
                        } }
            } 
            
        return $cap;
        
    }
    
        public function getTruckmaindriver($truckId){
        
        $drivers= Cardrivers::find()->where(['carId'=>$truckId,'status'=>1])->all();
        $maindriver=null;
        
        if ($drivers != null){
            foreach ($drivers as $driver){
                $check=Cardrivers::find()->where(['userId'=>$driver->userId,'status'=>1])->all();
                foreach ($check as $ch){
                    if ($ch->carId != $driver->carId){
                        break;
                    }else{
                        if (Uzers::findOne($driver->userId)->status==1) {
                            $maindriver=$driver->userId;
                        }else{
                            $dupdate=Cardrivers::findOne($driver->id);
                            $dupdate->status=0;
                            $dupdate->save();
                        }
                    }
                }
            }
        }
        return $maindriver;
    }
        
    public function getActiveDriverStatus($car,$driver){
        
        $adriver=Null;
        $driver= Cardrivers::find()->where(['carId'=>$car,'status'=>1,'userId'=>$driver])->all();
        
        if ($driver != null) { $adriver=$driver; } 
        
        return $adriver;
        
    }
    
    
    
    public function deactivateActiveDriver($hsId,$dId){
        $status= false;
     
        $drivers= Cardrivers::find()
        ->where(['userId'=>$dId,'status'=>1])
        ->all();
        
        foreach ($drivers as $driver){
                $driver->status=0;
                $driver->save();
                
                $status=true;
        }
        
        return $status;
    }
    
    public function getDriverStrength($userId){
        
        $drivers= Cardrivers::find()->where(['userId'=>$userId])->all();
        $strength=0;
        
        if ($drivers != null){
            foreach ($drivers as $driver){
                $strength=Movements::driverAllMovements($driver->id);
            }
        }
        return $strength;
    }
    
    public function setCardriverInFuel($fueId){
        
        $fue= Fuelrequest::findOne($fueId);
        $truckId=$fue->truckId;
        $driver= Cardrivers::find()->where(['carId'=>$truckId])->one();
        if ($driver!=null){
        $fue->driverId=$driver->id;
        $fue->save();
        }
        
        return $driver->id;
        
    }
    
        public function getUserDriverId($id){
      
        $driverIds=null;
        
        $mods= Cardrivers::find()->where("userId='$id'")->all();
       
        if ($mods != null){
            foreach ($mods as $mod){
                        $driverIds[]=$mod->id;
            }
        }
        
        return $driverIds;
    }
}
