<?php

namespace app\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use app\models\Bills;

/**
 * BillsSearch represents the model behind the search form of `app\models\Bills`.
 */
class BillsSearch extends Bills
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'billby', 'userId', 'paid', 'company'], 'integer'],
            [['date', 'dueDate','clientId'], 'safe'],
            [['numbername'], 'string', 'max' => 10],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Bills::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'sort'=> ['defaultOrder' => ['date'=>SORT_DESC]],
            'pagination' => [
                'pageSize' => 50,
            ],
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }
       $query->andFilterWhere([
            'id' => $this->numbername!=null?Bills::reverseBillNo($this->numbername):$this->numbername,
            'billby' => $this->billby,
            'date' => $this->date,
            'userId' => $this->userId,
            'dueDate' => $this->dueDate,
            'paid' => $this->paid,
            'clientId' =>$this->clientId==null?$this->clientId:Clients::getClientId($this->clientId),
            'company' => \Yii::$app->session->get('company'),
        ]);
        
       

        return $dataProvider;
    }
    
    
    public function searchpaid($params)
    {
        $query = Bills::find();
        
        // add conditions that should always apply here
        
        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);
        
        $this->load($params);
        
        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }
        
        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'billby' => $this->billby,
            'date' => $this->date,
            'userId' => \Yii::$app->user->getId(),
            'dueDate' => $this->dueDate,
            'paid' => 0,
            'company' => \Yii::$app->session->get('company'),
        ]);
        
        return $dataProvider;
    }
}